<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class Cors
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
            $response = $next($request);
    
            // Add the CORS headers
            $response->header('Access-Control-Allow-Origin', 'http://localhost');
            $response->header('Access-Control-Allow-Methods', 'GET, POST, PUT, DELETE');
            $response->header('Access-Control-Allow-Headers', 'Content-Type, Authorization');
    
            return $response;
 }
}
