<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Timeclock Admin Panel | Employee Selection</title>

    @include('partials.headerLinks')
    <style type="text/css">
        .activeSM {
            background-color: white !important;
            /* #38283c !important;*/
        }

        #loading-img {
            background: url(img/load.gif) center center no-repeat;
            height: 100%;
            z-index: 20;
        }

        .overlay {
            background: #e9e9e9;
            display: none;
            position: absolute;
            top: -100px;
            right: -100px;
            bottom: 0;
            left: 0;
            height: 900px;
            opacity: 0.5;
            z-index: 999;
        }
    </style>
    <script>
        const loginUrl = "{{ route('login') }}";

        if (!localStorage.login_timeclock_admin) {
            window.stop();
            window.location.replace(loginUrl);
        }
    </script>
</head>

<body>
    <div id="wrapper">

        @include('partials.navbar')
        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                @include('partials.top-bar')

            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><strong>Advance</strong></h2>
                </div>
                <div class="col-lg-2">
                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="container">
                    <div class="row">
                        <div class="col-sm-10">
                            <div class="row" style="padding-right:20px;margin-top:20px">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>Employee Name</label>
                                        <input type="text" id="name" name="name" list="names" placeholder="Enter Name"
                                            class="form-control"/>
                                            <datalist id="names">
                                              </datalist>
                                    </div>
                                    <div class="fs-4" style="color:red;" id="error_name"> </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>Amount</label>
                                        <input type="number" min="1" id="amount" name="amount" placeholder="Enter Amount"
                                            class="form-control" />
                                    </div>
                                    <div class="fs-4" style="color:red;" id="error_amount"> </div>
                                </div>
                            </div>
                            <div class="row" style="padding-right:20px;margin-top:20px">

                                <div class="col-sm-6">
                                    <div class="row" style="padding:0 16px;">
                                        <div class="col-12">
                                            <div class="form-group">
                                                <label>Location</label>
                                                <select class="form-control" id="location_list" name="location_list">
                                                    <!-- Dynamically Appending All Locations -->
                                                </select>
                                            </div>
                                            <div class="fs-4" style="color:red;" id="error_location"> </div>
                                        </div>

                                    </div>

                                </div>
                                <div class="col-sm-12 d-flex flex-column">
                                    <canvas id="signature-pad" width="920" height="180"
                                        style="touch-action: initial;background:white;"></canvas>
                                    <div class="fs-4" style="color:red;" id="sign"></div>
                                    <button id="clear-button">Clear</button>

                                </div>
                            </div>


                            <div class="row" style="padding-right:20px;margin-top:20px">
                                <div class="col-sm-12">
                                    <div>
                                        <button id="save-button"
                                            style="background-color: #224ea6;border-color: #224ea6;color: white; width: 100%; height: 40px; font-size: 20px; margin-bottom : 20px"
                                            class="ladda-button ladda-button-demo btn btn-primary m-t-n-xs"
                                            type="submit" data-style="zoom-in">
                                            <span class="ladda-label">Save</span><span class="ladda-spinner"></span>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-2"></div>
                    </div>
                </div>
            </div>

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none">
                <!-- Delete Row -->
                <button id="swal_btn2" type="button" style="display:none">
                    <!-- Active/Inactive row -->
                    <button id="swal_btn3" type="button" style="display:none">
        </div>
    </div>

    <!-- Image Loader -->
    <div class="overlay">
        <div id="loading-img"></div>
    </div>
    <!-- Image Loader END -->

    @include('partials.scriptLinks')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/signature_pad/1.5.3/signature_pad.min.js"></script>
    <!-- Page-Level Scripts -->
    <script>
        const AllEmployeeUrl = "{{ route('allempolyees') }}";
        const ActiveLocations = '{{ route('allocationsactive') }}';
        const AddPaymentAdvance = '{{ route('AddPaymentAdvance') }}';
       $(document).ready(function() {
            $("#side5").addClass("activeSM");
            $("#side5 a").css("color", "#224ea6");
        });
        const validate = () => {
            var name = document.getElementById('name');
            var amount = document.getElementById('amount');
            var location = document.getElementById('location_list');
            var error_name = document.getElementById('error_name');
            var error_amount = document.getElementById('error_amount');
            var error_location = document.getElementById('error_location');
            if (name.value == "" && amount.value == "") {
                error_name.innerHTML = " ";
                error_amount.innerHTML = " ";
                error_name.innerHTML = "This feild is required";
                error_amount.innerHTML = "This feild is required";
                //    error_location.innerHTML  = "This feild is required";
                return false;
            } else {
                if (name.value == "") {
                    error_name.innerHTML = " ";
                    error_amount.innerHTML = " ";
                    error_name.innerHTML = "This feild is required";
                    return false;

                } else if (amount.value == "") {
                    error_amount.innerHTML = " ";
                    error_amount.innerHTML = " ";
                    //    error_location.innerHTML  = " ";
                    error_amount.innerHTML = "This feild is required";
                    return false;

                } else {
                    error_name.innerHTML = " ";
                    error_amount.innerHTML = " ";
                    //    error_location.innerHTML  = " ";
                    return true;
                }
            }
        }
        const allEmployees = () =>{
            $.ajax({
                url: AllEmployeeUrl,
                type: "GET",
                success: function(data) {
                    console.log(data)
                    if(data.status == "success"){
                        const $emp_list = document.getElementById('names');
                        console.log($emp_list);
                        data.Data.forEach(element => {
                        //  console.log(element);
                        const name = element.emp_fname+" "+element.emp_lname;
                        $('#names').append('<option value="' + element.emp_username + '">' + name + '</option>');
                        //  console.log(emp);
                       });
                    }
                }
            });
        }
        allEmployees();
        function dataURLtoBlob(dataURL) {
            const arr = dataURL.split(',');
            const mime = arr[0].match(/:(.*?);/)[1];
            const bstr = atob(arr[1]);
            let n = bstr.length;
            const u8arr = new Uint8Array(n);
            while (n--) {
                u8arr[n] = bstr.charCodeAt(n);
            }
            return new Blob([u8arr], {
                type: mime
            });
        }

        // Select the canvas element
        const canvas = document.getElementById('signature-pad');

        // Initialize the signature pad
        const signaturePad = new SignaturePad(canvas);
        const clearButton = document.getElementById('clear-button');

        clearButton.addEventListener('click', () => {
            signaturePad.clear();
        });
        // const clearButton = document.getElementById('clear-button');

        clearButton.addEventListener('click', () => {
            signaturePad.clear();
        });

        const signatureData = signaturePad.toDataURL(); // Returns the signature as a data URL
        function saveSignature() {
            var validateCheck = validate();
            var signValue = !signaturePad.isEmpty();
            console.log(!signaturePad.isEmpty(), "asda");

            if (signValue == false && !validateCheck) {
                // alert('Please provide a signature before saving.');
                document.getElementById('sign').innerHTML = "";
                document.getElementById('sign').innerHTML = "Please provide a signature before saving";
                // alert("error");
                // return;
            } else if (!validateCheck) {
                document.getElementById('sign').innerHTML = "";
            } else if (signValue == false) {
                document.getElementById('sign').innerHTML = "Please provide a signature before saving";
            } else {
                // Get the signature as a data URL
                const signatureData = signaturePad.toDataURL();
                const signatureBlob = dataURLtoBlob(signatureData);
                // Create a link element to download the image
                const link = document.createElement('a');
                document.getElementById('sign').innerHTML = "";
                addAdvance(signatureBlob);
            }


            //   link = signatureData;
            //   console.log( signatureData);
            //   link.download = 'signature.png'; // You can specify the filename here

            // Trigger a click event on the link to initiate the download
            // link.click();
        }

        // Attach an event listener to a "Save" button
        const saveButton = document.getElementById('save-button');
        saveButton.addEventListener('click', saveSignature);

        function addAdvance(link) {
            console.log(link)
            const date = new Date().toLocaleString('en-GB', {
                hour12: false,
            });
            const dateNow = date.split(',');
            const manager = localStorage.getItem('emp_username');
            const name = document.getElementById('name').value;
            const amount = document.getElementById('amount').value;
            const location = document.getElementById('location_list').value;
            const dateComponents = dateNow[0].split('/');

// Rearrange the components to "mm/dd/yyyy" format
const formattedDate = `${dateComponents[1]}/${dateComponents[0]}/${dateComponents[2]}`;
// alert(formattedDate);
            const formData = new FormData();
            formData.append('manager_name', manager);
            formData.append('employee_id', name);
            formData.append('amount', amount);
            formData.append('location', location);
            formData.append('date', formattedDate);
            formData.append('time', dateNow[1]);
            formData.append('advance_type', "loan");
            formData.append('photo', link);
            console.log(formData, "formdata");
            $.ajax({
                url: AddPaymentAdvance,
                type: 'POST',
                data: formData,
                processData: false, // Prevent jQuery from processing the data
                contentType: false, // Set the content type to false to let the browser set it automatically
                success: function(data) {
                    if (data.status == "success") {
                        setTimeout(function () {
                                              Swal.fire({
    title: "SUCCESS",
    text: "Advance Send Successfully!",
    icon: "success",
    confirmButtonColor: "#224ea6",
    showConfirmButton: false,
    // timer: 6000, // Set the timer to 5000 milliseconds (5 seconds)
    didOpen: function () {
        // You can add code here to run when the alert is shown
    }
});
   
}, 3000);
 setTimeout(function () {
    window.location.reload();
}, 4000);

                    }else if(data.status == "Emp_Error"){
                        swal({
                            title: "ERROR",
                            text: "User doesn't exist",
                            type: "error",
                            confirmButtonColor: "red",
                            closeOnConfirm: false
                        }, function() {
                            window.location.reload();
                        });
                    }else{
                        swal({
                            title: "ERROR",
                            text: "Something went wrong",
                            type: "error",
                            confirmButtonColor: "red",
                            closeOnConfirm: false
                        }, function() {
                            window.location.reload();
                        });
                    }
                    // Handle the response from the backend
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    // Handle errors
                }
            });
        }

        function getAllLocations() {
            var $list = $("#location_list");
            $list.empty();

            $.ajax({
                url: ActiveLocations,
                type: "GET",
                success: function(data) {
                    var dat = data;

                    if (dat.status == "success") {
                        $.each(dat.Data, function(index, obj) {
                            if (index == 0) {

                                $list.append('<option value="' + obj.location_name + '">' + obj
                                    .location_name + '</option>');
                            } else {
                                $list.append('<option value="' + obj.location_name + '">' + obj
                                    .location_name + '</option>');
                            }
                        });
                    } else {
                        // alert("error");
                    }
                    $(".overlay").hide();
                },
                error: function(data) {
                    $(".overlay").hide();
                    // alert("error");
                }
            });
        }
        getAllLocations();
    </script>
</body>

</html>
