<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Timeclock Admin Panel | Advance History</title>

    @include('partials.headerLinks')

    <style type="text/css">
        .activeSM {
            background-color: white !important;
            /* #38283c !important;*/
        }

        #loading-img {
            background: url(img/load.gif) center center no-repeat;
            height: 100%;
            z-index: 20;
        }

        .overlay {
            background: #e9e9e9;
            display: none;
            position: absolute;
            top: -100px;
            right: -100px;
            bottom: 0;
            left: 0;
            height: 900px;
            opacity: 0.5;
            z-index: 999;
        }
    </style>
    <script>
        const loginUrl = "{{ route('login') }}";

        if (!localStorage.login_timeclock_admin) {
            window.stop();
            window.location.replace(loginUrl);
        }
    </script>
</head>

<body>
    <div id="wrapper">
        @include('partials.navbar')

        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                @include('partials.top-bar')

            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><strong>Advance History</strong></h2>
                </div>
                <div class="col-lg-2">
                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="container">
                    <div class="row">
                        <div class="col-sm-10">
                            <div class="row" style="padding-right:20px;margin-top:20px">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>From</label>
                                        <input type="date" id="from_date" name="from_date" class="form-control" />
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>To</label>
                                        <input type="date" id="to_date" name="to_date" class="form-control" />
                                    </div>
                                </div>
                            </div>
                            <div class="row" style="padding-right:20px;margin-top:20px">
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label>Choose Employee</span></label>
                                        <select class="form-control" id="employee_list" name="employee_list"
                                            required="">
                                            <!-- Dynamically Appending All Employees -->
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row" style="padding-right:20px;margin-top:20px">
                                <div class="col-sm-12">
                                    <div>
                                        <button onclick="search()"
                                            style="background-color: #224ea6;border-color: #224ea6;color: white; width: 100%; height: 40px; font-size: 20px; margin-bottom : 20px"
                                            class="ladda-button ladda-button-demo btn btn-primary m-t-n-xs"
                                            type="submit" data-style="zoom-in">
                                            <span class="ladda-label">Search</span><span class="ladda-spinner"></span>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-2"></div>
                    </div>
                </div>
            </div>
            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none">
                <!-- Delete Row -->
                <button id="swal_btn2" type="button" style="display:none">
                    <!-- Active/Inactive row -->
                    <button id="swal_btn3" type="button" style="display:none">
        </div>
    </div>

    <!-- Image Loader -->
    <div class="overlay">
        <div id="loading-img"></div>
    </div>
    <!-- Image Loader END -->

    @include('partials.scriptLinks')

    <!-- Page-Level Scripts -->
    <script>
        const NextPage = "{{ route('advance-details') }}";
        const AdvanceLoanTotal = "{{ route('AdvanceLoanTotal') }}";
        // const AdvanceLoanTotal = "https://kingwaiver.com/Panama_dup/timeclock/apis/api/AdvanceLoanTotal";
        const GwtRul = "{{ route('allempolyees') }}";
        var l = $('.ladda-button-demo').ladda();

        $(document).ready(function() {
            $(".overlay").show();

            var tempDate = getCurrentdate();
            $('#from_date').val(tempDate);
            $('#to_date').val(tempDate);

            $('#emp_name').html(localStorage.Employee_Name);

            getAllEmployees();

         $("#side6").addClass("activeSM");
            $("#side6 a").css("color", "#224ea6");
        });

        function getAllEmployees() {
            var $list = $("#employee_list");
            $list.empty();

            $.ajax({
                url: GwtRul,
                type: "GET",
                success: function(data) {
                    // var dat = jQuery.parseJSON(data);
                    var Employees = [];

                    if (data.status == "success") {
                        $.each(data.Data, function(index, obj) {
                            Employees.push(obj.emp_username);
                            $list.append('<option value="' + obj.emp_username + '">' + obj.emp_fname +
                                ' ' + obj.emp_lname + '</option>');
                        });

                        localStorage.AllEmployees = JSON.stringify(Employees);
                    } else {
                        alert("error");
                    }
                    $(".overlay").hide();
                },
                error: function(data) {
                    $(".overlay").hide();
                    alert("error");
                }
            });
        }

        function getCurrentdate() {
            var date = new Date();
            var day = date.getDate();
            var month = date.getMonth() + 1;
            var year = date.getFullYear();
            var hours = date.getHours();
            var mins = date.getMinutes();

            if (month < 10) {
                month = "0" + month;
            }

            if (day < 10) {
                day = "0" + day;
            }

            date = year + "-" + month + "-" + day;

            return date;
        }

        function search() {
            l.ladda('start');

            var from_date = $('#from_date').val();
            from_date = changeDateFormat(from_date);
            var to_date = $('#to_date').val();
            to_date = changeDateFormat(to_date);
            var employee_list = $('#employee_list').val();
            var employee_list2 = $('#employee_list :selected').text();

            localStorage.AdvanceEmployee = employee_list2;
            localStorage.selectedweek = from_date + "-" + to_date;
            apiCall(from_date, to_date, employee_list);
        }

        function changeDateFormat(date) {
            var temp = date.split('-');
            var newdate = temp[1] + '/' + temp[2] + '/' + temp[0];
            return newdate;
        }

        function apiCall(date1, date2, employee) {
            $.ajax({
                url: AdvanceLoanTotal,
                type: "GET",
                data: {
                    "date1": date1,
                    "date2": date2,
                    "employee_id": employee
                },
                success: function(data) {
                    if (data.status == "success") {
                        l.ladda('stop');
                        localStorage.AdvanceLoan = data.emp_advance;
                        localStorage.AdvanceReturned = data.emp_advance_returned;
                        localStorage.From_Date = date1;
                        localStorage.To_Date = date2;
                        window.location.href = NextPage;
                    } else if (data.status == "failed") {
                        l.ladda('stop');
                        swal({
                            title: "ERROR",
                            text: "No information found",
                            type: "error",
                            confirmButtonColor: "red",
                            closeOnConfirm: false
                        }, function() {
                            window.location.reload();
                        });
                    }
                },
                error: function(data) {
                    l.ladda('stop');
                    swal({
                            title: "ERROR",
                            text: "No information found",
                            type: "error",
                            confirmButtonColor: "red",
                            closeOnConfirm: false
                        }, function() {
                            window.location.reload();
                        });
                }
            });
        }
    </script>
</body>

</html>
