<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Timeclock Admin Panel | Employee Selection</title>

    @include('partials.headerLinks')
    <style type="text/css">
        .activeSM {
            background-color: white !important;
            /* #38283c !important;*/
        }

        #loading-img {
            background: url(img/load.gif) center center no-repeat;
            height: 100%;
            z-index: 20;
        }

        .overlay {
            background: #e9e9e9;
            display: none;
            position: absolute;
            top: -100px;
            right: -100px;
            bottom: 0;
            left: 0;
            height: 900px;
            opacity: 0.5;
            z-index: 999;
        }
    </style>
    <script>
        const loginUrl = "{{ route('login') }}";

        if (!localStorage.login_timeclock_admin) {
            window.stop();
            window.location.replace(loginUrl);
        }
    </script>
</head>

<body>
    <div id="wrapper">

        @include('partials.navbar')
        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                @include('partials.top-bar')

            </div>
            <div class="row wrapper border-bottom  page-heading" style="background-color: #1fa7d9;">
                <div class="col-lg-10">
                    <h2 style="text-align: center;margin-left:95px;color:#fff;"><strong>Weekly Report</strong></h2>
                </div>
                <div class="col-lg-2">
                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="container">
                    <div class="row">
                        <div class="col-sm-10">
                            <div class="row" style="padding-right:20px">
                               
                            </div>
                            <div class="row" style="padding-right:20px;margin-top:20px">
                                <div class="col-sm-6">
                                    <div class="row" style="padding:0 16px;">
                                        <div class="col-12">
                                            <div class="form-group">
                                                <label>Choose Location</span></label>

                                                <select class="form-control" id="location_list" name="location_list"
                                                    required="">
                                                    <!-- Dynamically Appending All Locations -->
                                                </select>
                                            </div>
                                        </div>

                                    </div>

                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>Choose Week</span></label>
                                        <select class="form-control" id="week_list" name="week_list"
                                            required="">
                                            <!-- Dynamically Appending All Employees -->
                                        </select>
                                    </div>
                                </div>

                                {{-- <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>Choose Location</label>
                                        <select class="form-control" id="location_list" name="location_list"
                                            required="">
                                            <!-- Dynamically Appending All Locations -->
                                        </select>
                                    </div>
                                </div> --}}
                            </div>
                            <div class="row" style="padding-right:20px;margin-top:20px">
                                <div class="col-sm-12">
                                    <div>
                                        <button onclick="search()"
                                            style="background-color: #224ea6;border-color: #224ea6;color: white; width: 100%; height: 40px; font-size: 20px; margin-bottom : 20px"
                                            class="ladda-button ladda-button-demo btn btn-primary m-t-n-xs"
                                            type="submit" data-style="zoom-in">
                                            <span class="ladda-label">Search</span><span class="ladda-spinner"></span>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-2"></div>
                    </div>
                </div>
            </div>

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none">
                <!-- Delete Row -->
                <button id="swal_btn2" type="button" style="display:none">
                    <!-- Active/Inactive row -->
                    <button id="swal_btn3" type="button" style="display:none">
        </div>
    </div>

    <!-- Image Loader -->
    <div class="overlay">
        <div id="loading-img"></div>
    </div>
    <!-- Image Loader END -->

    @include('partials.scriptLinks')

    <!-- Page-Level Scripts -->
    <script>
        // const AllEmpUrl = "{{ route('allempolyees') }}";
        const AllLocUrl = '{{ route('allocationsactive') }}';
        const nextpage = '{{ route('weekly-report-graph') }}';

        // const AllLocUrl = "{{ route('alllocations') }}";
        // const InActiveLocations = '{{ route('all_locations_inactive') }}';
        const ViewOnClockEmployees = "{{ route('ViewOnClockEmployees') }}";
        var l = $('.ladda-button-demo').ladda();

        $(document).ready(function() {
            $(".overlay").show();

            var tempDate = getCurrentdate();
            console.log(tempDate, "tempDate");
            var lastFourWeeks = calculateLastFourWeeks();
            lastFourWeeks.forEach(element => {
                $('#week_list').append(
                    '<option>'+element.start+'-'+element.end+'</option>'
                )
            });
            // calculateLastFourWeeks();
            $('#from_date').val(tempDate);
            $('#to_date').val(tempDate);

            $('#emp_name').html(localStorage.Employee_Name);
            getAllLocations();

            $("#side10").addClass("activeSM");
            $("#side10 a").css("color", "#224ea6");
        });

        function calculateLastFourWeeks() {
            var lastFourWeeks = [];

            for (var i = 0; i < 4; i++) {
                var today = new Date();
                today.setDate(today.getDate() - i * 7);

                // Find the current week's Monday
                var startOfCurrentWeek = new Date(today);
                startOfCurrentWeek.setDate(today.getDate() - (today.getDay() - 1));

                // Find the current week's Sunday
                var endOfCurrentWeek = new Date(today);
                endOfCurrentWeek.setDate(today.getDate() + (7 - today.getDay()));

                lastFourWeeks.push({
                    start: formatDate(startOfCurrentWeek),
                    end: formatDate(endOfCurrentWeek)
                });
            }

            return lastFourWeeks;
        }

        function formatDate(date) {
            var dd = date.getDate();
            var mm = date.getMonth() + 1;
            var yyyy = date.getFullYear();

            if (dd < 10) {
                dd = '0' + dd;
            }

            if (mm < 10) {
                mm = '0' + mm;
            }

            return mm + '/' + dd + '/' + yyyy;
        }

        // Example usage
        var lastFourWeeks = calculateLastFourWeeks();
        console.log(lastFourWeeks);

        function formatDate(date) {
            var dd = date.getDate();
            var mm = date.getMonth() + 1;
            var yyyy = date.getFullYear();

            if (dd < 10) {
                dd = '0' + dd;
            }

            if (mm < 10) {
                mm = '0' + mm;
            }

            return mm + '/' + dd + '/' + yyyy;
        }

        // Example usage



        function formatDate(date) {
            var dd = date.getDate();
            var mm = date.getMonth() + 1;
            var yyyy = date.getFullYear();

            if (dd < 10) {
                dd = '0' + dd;
            }

            if (mm < 10) {
                mm = '0' + mm;
            }

            return mm + '/' + dd + '/' + yyyy;
        }

        

        function getAllLocations() {
            var $list = $("#location_list");
            $list.empty();

            $.ajax({
                url: AllLocUrl,
                type: "GET",
                success: function(data) {
                    var dat = data;

                    if (dat.status == "success") {
                        $.each(dat.Data, function(index, obj) {
                            if (index == 0) {
                                // $list.append('<option value="All" selected>All</option>');
                                $list.append('<option value="' + obj.location_name + '">' + obj
                                    .location_name + '</option>');
                            } else {
                                $list.append('<option value="' + obj.location_name + '">' + obj
                                    .location_name + '</option>');
                            }
                        });
                    } else {
                        // alert("error");
                    }
                    $(".overlay").hide();
                },
                error: function(data) {
                    $(".overlay").hide();
                    // alert("error");
                }
            });
        }

        function getCurrentdate() {
            var date = new Date();
            var day = date.getDate();
            var month = date.getMonth() + 1;
            var year = date.getFullYear();
            var hours = date.getHours();
            var mins = date.getMinutes();

            if (month < 10) {
                month = "0" + month;
            }

            if (day < 10) {
                day = "0" + day;
            }

            date = year + "-" + month + "-" + day;

            return date;
        }

        function search() {
            l.ladda('start');
            var weeklyInput = $('#week_list').val();
            console.log(weeklyInput,"weeklyInput");
            const splitedArr = weeklyInput.split('-');
            console.log(splitedArr,"splitedArr");
            // var from_date = changeDateFormat(splitedArr[0]);   
            // var to_date = changeDateFormat(splitedArr[1]);  
            //  alert(splitedArr);
            // from_date = changeDateFormat(from_date);
            // // var to_date = $('#to_date').val();
            // to_date = changeDateFormat(to_date);
            var employee_list = "All";
            var location_list = $('#location_list').val();

            // localStorage.selectedweek = from_date + "-" + to_date;
            apiCall(weeklyInput, location_list, employee_list);
        }

        function changeDateFormat(date) {
            var temp = date.split('-');
            var newdate = temp[1] + '/' + temp[2] + '/' + temp[0];
            return newdate;
        }

        function apiCall(date1, location, employee) {
            $.ajax({
                url: ViewOnClockEmployees,
                type: "GET",
                data: {
                    "location": location,
                    "employee_id": employee
                },
                success: function(data) {
                    if (data.status == "success") {

                        if (data.data.length > 0) {
                            l.ladda('stop');
                            localStorage.EmployeesObject = JSON.stringify(data.data);
                            // localStorage.From_Date = date1;
                            // localStorage.To_Date = date2;
                            localStorage.Selected_Loc = location;
                            localStorage.Selected_Week= date1;
                            window.location.href = nextpage;
                        } else {
                            swal({
                                title: "No Details",
                                text: "Employee has no Working hours During the Selected Day.",
                                type: "warning",
                                confirmButtonColor: "#DD6B55",
                            });
                        }


                    } else if (data.status == "failed") {
                        l.ladda('stop');
                        swal({
                            title: "No Details",
                            text: "No information found.",
                            type: "warning",
                            confirmButtonColor: "#DD6B55",
                        });
                        // alert(data.error);
                    } else {
                        swal({
                            title: "No Details",
                            text: "No information found.",
                            type: "warning",
                            confirmButtonColor: "#DD6B55",
                        });
                    }
                },
                error: function(data) {
                    console.log(data);
                    l.ladda('stop');
                    // alert("error");
                }
            });
        }
    </script>
</body>

</html>
