<!DOCTYPE html>
<html>
<head>
    <title>Timeclock Admin Web | Login</title>
    <link rel="icon" href="<?php echo e(asset('/fav-icon-large.png')); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">

    <!-- Ladda style -->
    <link href="css/ladda-themeless.min.css" rel="stylesheet">
    
    <style>
    body
    {
        font-family: Arial, Helvetica, sans-serif;
    }
    
    .imgcontainer 
    {
        text-align: center;
        margin: 24px 0 12px 0;
    }
    
    img.avatar 
    {
        width: 40%;
        border-radius: 50%;
    }
    
    .container 
    {
        padding: 16px;
    }
    </style>
    
    <script>
        // alert('alert');  
        const lognedInUrl = "<?php echo e(route('payroll_report')); ?>";
        if (localStorage.login_timeclock_admin)
        {
            window.stop();
            window.location.replace(lognedInUrl);
        }
    </script>
</head>
<body>
      <div class="imgcontainer">
        <img src="img/logo.png" width="150">
      </div>
    
      <div class="container">
        <div class="row">
            <div class="col-sm-3"></div>
            <div class="col-sm-6">
                <center>
                    <h1>Admin Login</h1>
                </center>
                <form id="loginForm">
                    <div class="form-group">
                        <label>Email</label>
                        <input type="email" id="email" name="email" placeholder="Email" class="form-control" required>
                    </div> 
                    <div class="form-group">
                        <label>Password</label>
                        <input type="password" id="psw" name="psw" placeholder="Password" class="form-control" required>
                    </div> 
                    <div class="form-group">
						<a href="https://kingwaiver.com/Panama_dup/timeclock/Adminpanel/forgot_password.html">
							Forgot Password?
						</a>
					</div>
                    <div>
                        <button style="background-color: #003399;border-color: #224ea6;color: white; width: 100%; height: 40px" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                <span class="ladda-label" style="font-size:20px">Submit</span><span class="ladda-spinner"></span>
                        </button>
                    </div>
                </form>
            </div>
            <div class="col-sm-3"></div>
        </div>
      </div>

    <!-- Successfully Added Vehicle Type -->
    <button id="swal_btn" type="button" style="display:none"></button>
    <!-- Vehicle Type not  Added -->
    <button id="swal_btn2" type="button" style="display:none"></button>
    
    <!-- Mainly scripts -->
    <script src="js/jquery-3.1.1.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    
    <!-- Sweet alert -->
    <script src="js/sweetalert.min.js"></script>

    <!-- Jquery Validate -->
    <script src="js/jquery.validate.min.js"></script>

    <!-- Ladda -->
    <script src="js/spin.min.js"></script>
    <script src="js/ladda.min.js"></script>
    <script src="js/ladda.jquery.min.js"></script>
    
    <script type="text/javascript">
        var errmsg;
        // const apiUrl =   "https://162c-124-29-208-75.ngrok-free.app/api/EmployeeSigninEmail";
        const apiUrl =   "<?php echo e(route('login_api')); ?>";
        // const apiUrl = '<?php echo e(route("login_api")); ?>';
        $(document).ready(function (e) 
        {
            $("#loginForm").validate({
                rules: 
                {
                    email:
                    {
                       required: true,
                    },
                    psw:
                    {
                       required: true,
                    },
                },
                messages: 
                {
                },
                submitHandler: function(form) 
                {
                    var l = $( '.ladda-button-demo' ).ladda();
                    l.ladda( 'start' );
    
                    var Email = $('#email').val();
                    var Password = $('#psw').val();
    
                    var formData = new FormData();
                    formData.append("emp_email", Email);
                    formData.append("emp_pass", Password);
                                        
                    $.ajax
                    ({
                        type:'POST',
                        // url:"https://kingwaiver.com/Panama_dup/timeclock/development/Test/public/api/EmployeeSigninEmail",
                        url:apiUrl,
                        data: formData,
                        contentType: false,
                        cache: false,
                        processData:false,
                        success: function(data)
                        {                        
                            if( data.status == "success" )
                            {
                                l.ladda('stop');
                                localStorage.login_timeclock_admin = "user";
                                localStorage.Employee_Name = data.emp_fullname;
                                localStorage.emp_username  = data.emp_username;
                                window.location.replace(lognedInUrl);
                            }
                            else if( data.status == "failed" )
                            {
                                l.ladda('stop');
                                errmsg = data.error;
                                swal_btn2.click();
                            }
                        },
                        error: function(data) 
                        {
                            alert("error");
                        }           
    
                    });                
                    return false; // extra insurance preventing the default form action
                }
            });
    
            $('#swal_btn2').click(function(){
                swal({
                    title: "Operation Unsuccessfull!",
                    text: errmsg,
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                });
            });
        });
    </script>
</body>
</html>
<?php /**PATH /home/adihai1972/public_html/timeclock_tj/Test/resources/views/auth/login.blade.php ENDPATH**/ ?>