<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Timeclock Admin Panel | Weekly Report</title>

    <?php echo $__env->make('partials.headerLinks', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <style type="text/css">
        .activeSM {
            background-color: white !important;
            /* #38283c !important;*/
        }

        .detailsBtn {
            background-color: #224ea6;
            color: white;
            border-color: #224ea6;
        }

        .btn-primary {
            width: 100%;
            color: #fff;
            background-color: #224ea6;
            border-color: #224ea6;
        }

        .btn-primary:hover {
            color: #fff;
            background-color: #224ea6;
            border-color: #224ea6;
        }

        .btn-primary:focus {
            color: #fff;
            background-color: #224ea6;
            border-color: #224ea6;
        }

        .not-allowed {
            pointer-events: auto ! important;
            cursor: not-allowed ! important;
            background-color: #fff;
        }
    </style>
    <script>
        const loginUrl = "<?php echo e(route('login')); ?>";

        if (!localStorage.login_timeclock_admin) {
            window.stop();
            window.location.replace(loginUrl);
        }
    </script>
</head>

<body>

    <div id="wrapper">
        <?php echo $__env->make('partials.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php echo $__env->make('partials.top-bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="row" style="font-size:24px;margin:20px 0px 0px 40px;">
                    <font>Location Name : </font>
                    <font id="selected_location" style="font-weight:800;color:#224ea6"></font><br>
                    <font>From Date : </font>
                    <font id="from_date" style="font-weight:800;color:#224ea6"></font><br>
                    <font>To Date : </font>
                    <font id="to_date" style="font-weight:800;color:#224ea6"></font><br>
                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                <div class="row">
                                    <center>
                                        <div class="col-xs-6">
                                            <h2 style="font-weight:800">Total Hours</h2>
                                            <h2 id="total_hours" style="font-weight:800;color:#224ea6"></h2>
                                        </div>
                                        <div class="col-xs-6">
                                            <h2 style="font-weight:800">Amount to Pay</h2>
                                            <h2 id="total_pay" style="font-weight:800;color:#224ea6"></h2>
                                        </div>
                                        <!--<div class="col-xs-4">
                                            <h2 style="font-weight:800">Advance Details</h2>
                                            <h2 id="total_advance" style="font-weight:800;color:#224ea6"></h2>
                                        </div>-->
                                    </center>
                                </div>

                                <table class="footable table table-stripped toggle-arrow-tiny" data-page-size="15">
                                    <thead>
                                        <tr>
                                            <th></th>
                                            <th>Name</th>
                                            <th>Date</th>
                                            <th>Total Hours</th>
                                            <!--<th>Total Extra Hours</th>-->
                                            <th>Amount to Pay</th>
                                            <th>Advance</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody id="payroll_list">
                                        <!-- Dynamically appending Locations List -->
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="6">
                                                <ul class="pagination pull-right"></ul>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                                <button onclick="SendMail()" style="width: 100%;background-color:#04aa6d;color:#fff;"
                                    id="sendMail" class="btn mb-2 ">Send Report to Email</button>
                                <button onclick="goBack()" class="btn btn-primary" style="margin-top: 10px;">Back</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none">
                <!-- Delete Row -->
                <button id="swal_btn2" type="button" style="display:none">
                    <!-- Active/Inactive row -->
                    <button id="swal_btn3" type="button" style="display:none">


        </div>
    </div>

    <?php echo $__env->make('partials.scriptLinks', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script src="<?php echo e(asset('js/jquery-3.1.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/jquery.metisMenu.js')); ?>"></script>
    <script src="<?php echo e(asset('js/jquery.slimscroll.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/dates.js')); ?>"></script>
    <script>
        const nextPageUrl = "<?php echo e(route('send-payroll-emp')); ?>";
        const ApiCall = "<?php echo e(route('SendHoursMail')); ?>";
        const goBackUrl = "<?php echo e(route('send-payroll')); ?>";
        var startDateRange;
        var endDateRange;
        var total_pay;
        var advanceTotal = 0;
        var Total_Hours;
        var Grand_Total_Hours = 0;
        var Grand_Total_Pay = 0;
        var emp_fullname;
        var clockin_date;
        var hours;
        var print;
        var perHourPay;
        var $list;
        var startDayofWeek, lastDayofWeek;
        var normalHours = 0;
        var overTimeHours = 0;
        var totalExtraHours = 0;
        var overtime = "NO";
        var EmployeeUsername;
        var EmployeeEmail;
        var EmployeeLoc;
        var EmployeePosition;
        var EmployeePassword;
        var EmployeeUsername;
        var DetailsExists = 0;
        var selectedLoc = localStorage.getItem('Selected_Loc');
        $(document).ready(function() {
            $('#emp_name').html(localStorage.Employee_Name);
            $('#selectedWeek').html(localStorage.selectedweek);

            $("#side9").addClass("activeSM");
            $("#side9 a").css("color", "#224ea6");

            assignValues();
            viewDetails();

            //Empty List
            $('#swal_btn').click(function() {
                swal({
                    title: "No Data",
                    text: "Employee has no Working hours During the Selected Week.",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                    closeOnConfirm: false
                }, function() {
                    // window.location.assign("employee_selection.php");
                });
            });

            $('#swal_btn2').click(function() {
                swal({
                    title: "No Details",
                    text: "Employee has no Working hours During the Selected Day.",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                });
            });
        });

        function assignValues() {
            startDateRange = localStorage.From_Date;
            endDateRange = localStorage.To_Date;

            $('#selected_location').html(localStorage.Selected_Loc);
            $('#from_date').html(startDateRange);
            $('#to_date').html(endDateRange);
        }

        function viewDetails() {
            $list = $("#payroll_list");
            $list.empty();

            var EmployeesObject = JSON.parse(localStorage.EmployeesObject);
            var Employees = JSON.parse(localStorage.AllEmployees);

            $.each(Employees, function(array_index, array_value) {
                clockin_date = "01/01/2020";
                perHourPay = 0;
                hours = 0;
                Total_Hours = 0;
                total_pay = 0;
                advanceTotal = 0;
                print = 0;
                totalExtraHours = 0;

                var tempStartDateTemp = startDateRange;
                var firstWeekCount = 0;
                var extraHours;

                while (dates.compare(tempStartDateTemp, endDateRange) != 1) {
                    getStartLastOfWeek(tempStartDateTemp);

                    extraHours = 0;

                    $.each(EmployeesObject, function(index, obj) {
                        if (array_value == obj.employee_id) {
                            var tempRange = dates.inRange(obj.date, startDayofWeek, lastDayofWeek);

                            if (tempRange) {
                                if (dates.compare(obj.date, startDateRange) == -1 || dates.compare(obj.date,
                                        endDateRange) == 1) {
                                    hours = checkClockout(obj);
                                    extraHours = parseFloat(extraHours) + parseFloat(hours);
                                } else {
                                    print = 1;
                                    perHourPay = parseFloat(obj.payroll_perhr);
                                    EmployeeUsername = obj.employee_id;
                                    //  = obj.employee_id;
                                    EmployeeUsername = obj.employee_id;
                                    EmployeeEmail = obj.employee_details[0].emp_email;
                                    EmployeePosition = obj.employee_details[0].current_work_loc;
                                    EmployeeUsername = obj.employee_id;
                                    console.log(obj.employee_details, "OBJ");
                                    //Calling function to get Employee Full Name
                                    emp_fullname = getEmployeeFullName(obj);

                                    //Calling function to save the latest Clockin Date of an Employee
                                    clockin_date = setLatestClockIn(index, clockin_date, obj);

                                    //Calling function to check whether Employee is still on Clock or Not
                                    hours = checkClockout(obj);

                                    extraHours = parseFloat(extraHours) + parseFloat(hours);

                                    //Calling function to Check if any overtime worked or not.
                                    check40Hours(extraHours, hours);

                                    Total_Hours = parseFloat(Total_Hours) + parseFloat(hours);

                                    var payCalculateNormal = parseFloat(perHourPay) * parseFloat(
                                        normalHours);
                                    var payCalculateOvertime = parseFloat(perHourPay * 1.5) * parseFloat(
                                        overTimeHours);

                                    total_pay = parseFloat(total_pay) + parseFloat((parseFloat(
                                            payCalculateNormal) + parseFloat(payCalculateOvertime))
                                        .toFixed(2));

                                    //Calling function to calculate Employee Advance
                                    advanceTotal = employeeAdvance(obj);
                                }
                            }
                        }
                    });

                    tempStartDateTemp = exactDate(lastDayofWeek, 1);
                    //firstWeekCount++;
                }

                printList(print);
            });

            if (DetailsExists == 0) {
                $list.append('<tr>' +
                    '<td colspan="5" style="color:red;font-size: 20px;"><strong>No Result Found.</strong></td>' +
                    '</tr>');
            }
        }

        /*function viewDetails2()
        {
            $list = $("#payroll_list");
            $list.empty();
            
            var EmployeesObject = JSON.parse(localStorage.EmployeesObject);
            var Employees = JSON.parse(localStorage.AllEmployees);
            
            $.each(Employees, function(array_index,array_value)
            {
                clockin_date = "01/01/2020";
                
                perHourPay = 0;
                hours = 0;
                Total_Hours = 0;
                total_pay = 0;
                advanceTotal = 0;
                print = 0;
                
                $.each(EmployeesObject, function(index,obj)
                {
                    if( array_value == obj.employee_id )
                    {
                        var tempRange = dates.inRange(obj.date,startDateRange,endDateRange);
                        
                        if(tempRange)
                        {
                            getStartLastOfWeek(obj.date);
                            
                            //alert(startDayofWeek + "====" + lastDayofWeek);
                            
                            print = 1;
                            perHourPay = parseFloat(obj.payroll_perhr);
                            
                            //Calling function to save the latest Clockin Date of an Employee
                            clockin_date = setLatestClockIn(index,clockin_date,obj);
                            
                            //Calling function to check whether Employee is still on Clock or Not
                            hours = checkClockout(obj);
                            
                            Total_Hours = parseFloat(Total_Hours) + parseFloat(hours);
                            total_pay   = parseFloat(total_pay) + parseFloat((parseFloat(perHourPay) * parseFloat(hours)).toFixed(2));
                            
                            //Calling function to get Employee Full Name
                            emp_fullname = getEmployeeFullName(obj);
                            
                            //Calling function to calculate Employee Advance
                            advanceTotal = employeeAdvance(obj);
                        }
                    }
                });
                
                printList(print);
            });
        }*/

        function employeeAdvance(obj) {
            var advanceTotal = 0;

            $.each(obj.advance_details, function(index2, obj2) {
                var tempresult = dates.compare(obj2.date, endDateRange);
                if (tempresult == -1 || tempresult == 0) {
                    if (obj2.advance_type == "loan") {
                        advanceTotal = advanceTotal + parseFloat(obj2.amount);
                    }
                }
            });

            return advanceTotal;
        }

        function getEmployeeFullName(obj) {
            var emp_fullname;

            $.each(obj.employee_details, function(index2, obj2) {
                emp_fullname = obj2.emp_fname + " " + obj2.emp_lname;
                overtime = obj2.overtime;
            });

            return emp_fullname;
        }

        function setLatestClockIn(index, clockin_date, obj) {
            if (index != 0) {
                var d1 = new Date(clockin_date);
                var d2 = new Date(obj.date);

                var tempresult = dates.compare(d1, d2);
                if (tempresult == -1) {
                    clockin_date = obj.date;
                }
            } else if (index == 0) {
                clockin_date = obj.date;
            }

            return clockin_date;
        }

        function checkClockout(obj) {
            var hours;

            if (obj.clock_out == 0) {
                hours = parseFloat(obj.working_hours);

                if (obj.breaks) {
                    var tempStartDate;
                    $.each(obj.breaks, function(index2, obj2) {
                        if (obj2.back_to_work_date) {
                            tempStartDate = obj2.back_to_work_date + " " + obj2.back_to_work_time;
                        } else {
                            tempStartDate = obj2.back_to_work_date;
                        }
                    });

                    if (tempStartDate) {
                        var startDate = new Date(tempStartDate);
                        var endDate = new Date();
                        var seconds = (endDate.getTime() - startDate.getTime()) / 1000;
                        hours = parseFloat(hours) + parseFloat(seconds);
                        hours = (hours / 3600).toFixed(2);
                    } else {
                        hours = parseFloat(hours);
                        hours = (hours / 3600).toFixed(2);
                    }
                } else {
                    var startDate = new Date(obj.clock_in);
                    var endDate = new Date();
                    var seconds = (endDate.getTime() - startDate.getTime()) / 1000;
                    hours = parseFloat(seconds);
                    hours = (hours / 3600).toFixed(2);
                }
            } else {
                hours = parseFloat(obj.working_hours);
                hours = (hours / 3600).toFixed(2);
            }

            return hours;
        }

        function getStartLastOfWeek(date) {
            var weekday = new Array(7);
            weekday[0] = "Sunday";
            weekday[1] = "Monday";
            weekday[2] = "Tuesday";
            weekday[3] = "Wednesday";
            weekday[4] = "Thursday";
            weekday[5] = "Friday";
            weekday[6] = "Saturday";

            var d = new Date(date);
            var temp = d.getDay();
            var DayofWeek = weekday[d.getDay()];

            if (temp == 1) {
                startDayofWeek = exactDate(date, 0);
                lastDayofWeek = exactDate(date, 6);
            } else if (temp == 0) {
                startDayofWeek = exactDate(date, -6);
                lastDayofWeek = exactDate(date, 0);
            } else {
                startDayofWeek = exactDate(date, temp - ((temp * 2) - 1));
                lastDayofWeek = exactDate(date, 7 - temp);
            }
        }

        function exactDate(date, day) {
            var targetDate = new Date(date);
            targetDate.setDate(targetDate.getDate() + day);

            // So you can see the date we have created
            var dd = targetDate.getDate();
            var mm = targetDate.getMonth() + 1; // 0 is January, so we must add 1
            var yyyy = targetDate.getFullYear();

            if (dd < 10) {
                dd = '0' + dd;
            }

            if (mm < 10) {
                mm = '0' + mm;
            }

            var dateString = mm + "/" + dd + "/" + yyyy;

            // So you can see the output
            return dateString;
        }

        function check40Hours(extraHours, hours) {
            if (overtime == "YES") {
                if (extraHours > 40) {
                    var temp = extraHours - hours; //45-10=35

                    if (temp < 40) //35
                    {
                        normalHours = 40 - temp;
                        overTimeHours = extraHours - 40;
                    } else {
                        normalHours = 0;
                        overTimeHours = hours;
                    }
                } else {
                    normalHours = hours;
                    overTimeHours = 0;
                }

                totalExtraHours = parseFloat(totalExtraHours) + parseFloat(overTimeHours);
            } else {
                normalHours = hours;
                overTimeHours = 0;
                totalExtraHours = 0;
            }
        }

        function AddCheck(id) {
            console.log(id.checked);
            var elem = document.getElementById(id);
            if (id.checked) {
                id.setAttribute("checked", "");
            } else {
                id.removeAttribute("checked", true);
            }
            // console.log(elem.hasAttribute("checked"));
        }

        function printList(print) {
            if (print == 1) {
                total_pay = total_pay.toFixed(2);
                advanceTotal = advanceTotal.toFixed(2);

                Grand_Total_Hours = Grand_Total_Hours + Total_Hours;
                Grand_Total_Pay = parseFloat(Grand_Total_Pay) + parseFloat(total_pay);

                $('#total_hours').html(Grand_Total_Hours.toFixed(2));
                $('#total_pay').html('$' + Grand_Total_Pay.toFixed(2));

                $list.append('<tr>' +
                    '<td><input class="checkbox mails" onclick="AddCheck(this);" id="' + emp_fullname +
                    '" type="checkbox" name="check" value="' + emp_fullname + ',' + EmployeeUsername + ',' +
                    Total_Hours + ',' + total_pay + ',' + clockin_date + ',' + selectedLoc + ',' + EmployeeEmail + ',' +
                    EmployeePosition + ','+advanceTotal+'"/></td>' +
                    '<td><strong>' + emp_fullname + '</strong></td>' +
                    '<td>' + clockin_date + '</td>' +
                    '<td>' + (Total_Hours).toFixed(2) + '</td>' +
                    //'<td>'+(Total_Hours - totalExtraHours).toFixed(2)+'</td>'+
                    //'<td style="color:red">'+totalExtraHours.toFixed(2)+'</td>'+
                    '<td>$' + total_pay + '</td>' +
                    '<td>' +
                    '<div class="btn-group">' +
                    '<button id="' + EmployeeUsername +
                    '" onclick ="viewAdvanceDetails(this.id);" class="btn-danger btn btn-xs">$' + advanceTotal +
                    '</button>' +
                    '</div>' +
                    '</td>' +
                    '<td>' +
                    '<div class="btn-group">' +
                    '<button id="' + EmployeeUsername +
                    '" onclick ="EmployeeDetails(this.id);" class="detailsBtn btn-white btn btn-xs">View Details</button>' +
                    '</div>' +
                    '</td>' +
                    '</tr>');

                DetailsExists = 1;
            }
        }
        var arr = [];

        // var arr2 = [];
        const SendMail = () => {
            var parent = document.getElementById('sendMail');
            // parent.setAttribute("disabled",true);
            parent.classList.add("not-allowed");
            // console.log(parent.setAttribute("disabled",true));
            $(".mails").each(function(index) {
                // Get the checkbox within the current element
                //   var checkbox = $(this).find("input[type='checkbox']");
                console.log(this.checked);
                // Check if the checkbox is checked
                if (this.checked) {
                    console.log(this.value);
                    const splitedArr = this.value.split(',');
                    console.log(splitedArr, "splitedArr");
                    const obj = {
                        name: splitedArr[0],
                        total_hours: splitedArr[2],
                        payment: splitedArr[3],
                        datetime: splitedArr[4],
                        location: splitedArr[7],
                        email: splitedArr[6],
                        adv: splitedArr[8],
                        date1:localStorage.From_Date,
                        date2:localStorage.To_Date
                    };
                    arr.push(obj);
                } else {
                    // alert("im not checked");
                }


            });
            if (arr.length > 0) {
                ApiCallFunc();
            } else {
                 swal({
                            title: "Warning!",
                            text: "Please Select an employee",
                            type: "error",
                            confirmButtonColor: "#224ea6",
                            closeOnConfirm: false
                        });
            }
            // window.location.reload();
            parent.classList.remove("not-allowed");
        }
        const ApiCallFunc = () => {
            event.preventDefault();
            $.ajax({
                type: 'POST',
                url: ApiCall,
                data: JSON.stringify(arr),
                contentType: 'application/json',
                dataType: 'JSON',
                cache: false,
                processData: false,
                success: function(data) {
                    // alert(data);
                    if (data.status == "success") {
                        swal({
                            title: "SUCCESS",
                            text: "Advance Send Successfully!",
                            type: "success",
                            confirmButtonColor: "#224ea6",
                            closeOnConfirm: false
                        }, function() {
                            window.location.reload();
                        });
                        // l.ladda( 'stop' );
                    } else {
                         swal({
                            title: "Error",
                            text: "Something went wrong",
                            type: "error",
                            confirmButtonColor: "#224ea6",
                            closeOnConfirm: false
                        }, function() {
                            window.location.reload();
                        });
                    }
                },
                error: function(data) {
                    // l.ladda( 'stop' );
                    // alert('error');
                }
            });

        }

        function EmployeeDetails(id) {
            localStorage.setItem("choosenEmployee", id);
            window.location.href = nextPageUrl;
        }

        function viewAdvanceDetails(id) {
            //alert(id);
        }

        function goBack() {
            window.location.href = goBackUrl;
        }
    </script>
</body>

</html>
<?php /**PATH /home/adihai1972/public_html/Panama_dup/timeclock/development/Test/resources/views/admin/send-payroll-details.blade.php ENDPATH**/ ?>