<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Timeclock Admin Panel | Who is on the clock</title>

    <?php echo $__env->make('partials.headerLinks', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <style type="text/css">
        .activeSM {
            background-color: white !important;
            /* #38283c !important;*/
        }

        .greenBtn {
            background-color: #fff;
            border-color: #90EE90;
            color: #90EE90;
            border: 2px solid;
            width: 100%;
            height: 40px;
            font-size: 20px;
            margin-bottom: 20px
        }
    </style>
    <script>
        const loginUrl = "<?php echo e(route('login')); ?>";

        if (!localStorage.login_timeclock_admin) {
            window.stop();
            window.location.replace(loginUrl);
        }
    </script>
</head>

<body>

    <div id="wrapper w-100 bg-primary">
        <?php echo $__env->make('partials.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php echo $__env->make('partials.top-bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><Strong>Who is on the clock</Strong></h2>
                </div>
                <div class="col-lg-2">
                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight">
                <div class="container">
                    <div class="row">
                        <div class="col-sm-10">
                            <div class="row locationContainer" style="padding-right:20px">

                                
                            </div>
                        </div>

                    </div>
                </div>
            </div>

            <?php echo $__env->make('partials.scriptLinks', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <script>
                const ViewLocationUrl = "<?php echo e(route('allocationsactive')); ?>";
                const NextPage = "<?php echo e(route('location-clock')); ?>";
                $(document).ready(function() {
                    $("#side1").addClass("activeSM");
                    $("#side1 a").css("color", "#224ea6");
                });
                const SingleLocation = (obj) => {
                    localStorage.setItem('onTheClock', obj);
                    // localStorage.setItem('onTheClockName',obj.location_name);
                    window.location.href = NextPage;
                }
                const AllLocation = () => {
                    localStorage.setItem('onTheClock', "All");
                    window.location.href = NextPage;
                }
                const ViewAllLocation = () => {
                    var parent = $('.locationContainer');
                    $.ajax({
                        url: ViewLocationUrl,
                        type: "GET",
                        success: function(data) {
                            console.log(data);
                            var dat = data;
                            let AllData = 'All';
                            if (dat.status == "success") {
                                $.each(dat.Data, function(index, obj) {

                                    parent.append(
                                        '<div class="col-sm-6">' +
                                        '<div>' +
                                        '<button style="background-color: #224ea6; border-color: #224ea6; color: white; width: 100%; height: 40px; font-size: 20px; margin-bottom: 20px;" class="btn btn-primary m-t-n-xs" onclick="SingleLocation(' +
                                        obj.location_id + ')">' +
                                        obj.location_name +
                                        '</button>' +
                                        '</div>' +
                                        '</div>'
                                    )
                                });
                               parent.append(
                                        '<div class="col-sm-6">' +
                                        '<div>' +
                                        '<button id="thisweek" class="btn btn-primary m-t-n-xs greenBtn" onclick="AllLocation();">' +
                                        'All Location' +
                                        '</button>' +
                                        '</div>' +
                                        '</div>'
                                    );
                            } else {
                                // alert("error");
                            }
                            $(".overlay").hide();
                        },
                        error: function(data) {
                            $(".overlay").hide();
                            // alert("error");
                        }
                    });
                }
                ViewAllLocation();
            </script>
</body>

</html>
<?php /**PATH /home/adihai1972/public_html/Panama_dup/timeclock/development/Test/resources/views/admin/who-is-on-clock.blade.php ENDPATH**/ ?>