<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Timeclock Admin Panel | Confirms Employees Hours</title>
    
    <link href="
    https://cdn.jsdelivr.net/npm/sweetalert2@11.7.31/dist/sweetalert2.min.css
    " rel="stylesheet">
    <?php echo $__env->make('partials.headerLinks', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <style type="text/css">
        .activeSM {
            background-color: white !important;
            /* #38283c !important;*/
        }

        .default {
            background-color: #224ea6;
            border-color: #224ea6;
            color: white;
            width: 100%;
            height: 80px;
            border-style: solid;
            font-size: 20px;
            margin-bottom: 20px;
        }

        div:where(.swal2-container) {
            display: grid;
            position: fixed;
            z-index: 10000 !important;
            inset: 0;
            box-sizing: border-box;
        }
        .swal2-popup {
  z-index: 50000; /* Increase the z-index of the SweetAlert popup */
}

.custom-swal-container::before {
  content: "";
  position: fixed;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background: rgba(0, 0, 0, 0.5); /* Transparent black background */
  z-index: 50000; /* Ensure it's behind the popup */
}

    </style>
    <script>
        const loginUrl = "<?php echo e(route('login')); ?>";

        if (!localStorage.login_timeclock_admin) {
            window.stop();
            window.location.replace(loginUrl);
        }
    </script>
</head>

<body>

    <div id="wrapper w-100 bg-primary">
        <?php echo $__env->make('partials.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php echo $__env->make('partials.top-bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><Strong>Employee Details</Strong></h2>
                </div>
                <div class="col-lg-12">
                    <h5 id="location_name">

                    </h5>
                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight">
                <div class="container">
                    <div class="row">
                        <div class="col-sm-10">
                            <div class="row locationContainer" style="padding-right:20px">

                                <div class="col-sm-6">

                                </div>
                                <div class="col-sm-6">
                                </div>
                                <div class="col-sm-12">
                                    <table class="table table-striped" style="background: #fff;" id="table2">
                                        <thead>
                                            <tr>
                                                <th colspan="5">Name</th>
                                                
                                                <th colspan="5">Position</th>
                                                <th colspan="5">In</th>
                                                <th colspan="5">Out</th>
                                                
                                                <th colspan="5"> Note</th>
                                                <th colspan="5"> Confirm by </th>
                                                <th colspan="5"> Confirm status </th>
                                            </tr>
                                        </thead>
                                        <tbody id="employee_list">
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <td colspan="6">
                                                    <ul class="pagination pull-right">
                                                    </ul>
                                                </td>
                                            </tr>
                                        </tfoot>
                                    </table>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                

            </div>

            <?php echo $__env->make('partials.scriptLinks', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.7.31/dist/sweetalert2.all.min.js"></script>
            <script>
                const ViewLocationUrl = "<?php echo e(route('allocationsactive')); ?>";
                const ViewEmployeesOnClock = "<?php echo e(route('ViewOnClockEmployees')); ?>";
                const confirmEmployeeUrl = "<?php echo e(route('confirm_employee')); ?>";
                const AddNoteUrl = "<?php echo e(route('add_note')); ?>";
                const updateTime = "<?php echo e(route('EditEmployeeTime')); ?>";

 $(document).ready(function() {
                    $("#side3").addClass("activeSM");
                    $("#side3 a").css("color", "#224ea6");
                });
                const localStorageName = localStorage.getItem('locationHours');
                const localStorageDate = localStorage.getItem('locationHoursDate');
                let location_name = document.getElementById('location_name');
                // const Employee_Name = localStorage.getItem('Employee_Name');
                location_name.textContent = `Location: ${localStorageName}`;
                let newDate = new Date(localStorageDate).toLocaleString('en-GB', {
                    hour12: false,
                });

                let dateArray = newDate.split(',');
                let RealDate = dateArray[0];
                const getAllLocation = () => {
                    $.ajax({
                        url: ViewLocationUrl,
                        type: "GET",
                        success: function(data) {
                            console.log(data);
                            if (data.status === "success") {
                                data.Data.forEach(element => {
                                    if (element.location_name == localStorageName) {
                                        ListingTable(element.location_name);
                                    }
                                });
                            }

                        },
                        error: function(error) {
                            console.error("Error:", error);
                        }
                    });
                };
                getAllLocation();
                const apiCall = (emp) => {
                    const now = new Date();
                   const day = String(now.getDate()).padStart(2, '0'); // Ensure two-digit formatting for day
                  const month = String(now.getMonth() + 1).padStart(2, '0'); // Months are zero-based, so add 1
                  const year = now.getFullYear();
                  const hours = String(now.getHours()).padStart(2, '0'); // Ensure two-digit formatting for hours
                  const minutes = String(now.getMinutes()).padStart(2, '0');

                  const formattedDate = `${month}/${day}/${year} ${hours}:${minutes}`;


                    // alert(date);
                    let dataArr = emp.split('/');
                    // alert(dataArr);
                    const data = {
                        employee_id: dataArr[0],
                        tc_id: dataArr[1],
                        comfirmby: Employee_Name,
                        date:formattedDate
                    }
                    $.ajax({
                        url: confirmEmployeeUrl,
                        type: "GET",
                        data: data,
                        success: function(data) {
                            if (data.status == "success") {
                              Swal.fire({
                           title: `${dataArr[2]}!`,
                           text: ` by Manager ${Employee_Name}!`,
                           icon: 'success'
                             }).then(() => {
                            // This code will execute when the "OK" button is clicked
                            window.location.reload();
                                  });

                                

                            }
                            // console.log(data);
                        },
                        error: function(error) {
                            console.error("Error:", error);
                            location.reload();
                        }
                    });
                }
                const ListingTable = (name) => {
                    const data = {
                        employee_id: 'All',
                        location: name
                    }
                    $.ajax({
                        url: ViewEmployeesOnClock,
                        type: "GET",
                        data: data,
                        success: function(data) {
                            // console.log(data);
                            if (data.status == 'success') {
                                console.log(data.data, "orDate");
                                data.data.forEach(element => {
                                    console.log("h1");
                                    const dateString1 = element.date;

                                    // JavaScript Date object
                                    const date2 = new Date(
                                        localStorageDate);
                                    date2.setHours(0, 0, 0, 0);
                                    // Parse the first date string and create a JavaScript Date object
                                    const date1Parts = dateString1.split("/");
                                    const year1 = parseInt(date1Parts[2], 10);
                                    const month1 = parseInt(date1Parts[0], 10) -
                                        1; // Months are zero-based in JavaScript
                                    const day1 = parseInt(date1Parts[1], 10);
                                    const date1 = new Date(year1, month1, day1);
                                    date1.setHours(0, 0, 0, 0);
                                    console.log("h2", date1.getTime() === date2.getTime());
                                    console.log("h3", date1, date2);
                                    var dispayClockin =convertTo12HourFormat(element.clock_in);
                                    var dispayClockout =convertTo12HourFormat(element.clock_out);
                                    // Compare the two Date objects
                                    if (date1.getTime() === date2.getTime()) {
                                        console.log("h3");

                                        var parent = $('#employee_list');
                                        var name = element.employee_details[0].emp_fname + " " +
                                            element.employee_details[0].emp_lname;
                                        console.log(parent, "parents");
                                        if (element.employee_details && element.clock_out != 0) {
                                            console.log(element.note == null);
                                            if (element.confirm_status == 1) {
                                                parent.append(
                                                    '<tr>' +
                                                    '<td colspan="5">' + name + '</td>' +
                                                    '<td colspan="5">' + element.position + '</td>' +
                                                    '<td colspan="5" id="' + element.clock_out + ',' +
                                                    element.tc_id +
                                                    ',' + element.clock_in +
                                                    ',clockin" onclick="updateClockinTime(this.id);" style="cursor:pointer;">' +
                                                    dispayClockin +
                                                    '</td>' +
                                                    '<td colspan="5" id="' + element.clock_in + ',' +
                                                    element.tc_id +
                                                    ',' + element.clockouts[0].clockout_id  +
                                                    ',clockout"  style="cursor:pointer;" onclick="updateClockinTime(this.id);">' +
                                                    dispayClockout + '</td>' +
                                                    '<td colspan="5"><button class="btn btn-sm btn-primary" id="' +
                                                    element.employee_id + '/' + element.tc_id + '/' +
                                                    element.note +
                                                    '"  onclick="NotePopup(this.id);">Note</button></td>' +
                                                    '<td colspan="5">Confirm by ' + element
                                                    .confirm_employee_fullname + '</td>' +
                                                    '<td>' +
                                                    '<button class="btn btn-sm btn-success" id="' +
                                                    element.employee_id + '/' + element.tc_id +
                                                    '/Unconfirmed" onclick="apiCall(this.id);">Confirmed</button>' +
                                                    '</tr>'
                                                )
                                            } else {
                                                parent.append(
                                                    '<tr>' +
                                                    '<td colspan="5">' + name + '</td>' +
                                                    '<td colspan="5">' + element.position + '</td>' +
                                                    '<td colspan="5" id="' + element.clock_out + ',' +
                                                    element.tc_id +
                                                    ',' + element.clock_in +
                                                    ',clockin" onclick="updateClockinTime(this.id);"  style="cursor:pointer;">' +
                                                    dispayClockin +
                                                    '</td>' +
                                                    '<td colspan="5" id="' + element.clock_in + ',' +
                                                    element.clockouts[0].clockout_id +
                                                    ',' + element.clock_out +
                                                    ',clockout"  style="cursor:pointer;" onclick="updateClockinTime(this.id);">' +
                                                    dispayClockout + '</td>' +
                                                    '<td colspan="5"><button class="btn btn-sm btn-primary disabled">Note</button></td>' +
                                                    '<td colspan="5"></td>' +
                                                    '<td>' +
                                                    '<button class="btn btn-sm btn-primary" id="' +
                                                    element.employee_id + '/' + element.tc_id +
                                                    '/Confirmed" onclick="apiCall(this.id);">Confirm it</button>' +
                                                    '</tr>' +
                                                    '</tr>'
                                                )
                                            }

                                        }
                                      
                                    } else {
                                        
                                    }
                                })
                            } else {
                                var parent = $('#employee_list');

                                parent.append(
                                    '<tr>' +
                                    '<td colspan="5" style="color:red;font-size: 20px;background:#fff;"><strong>No Result Found.</strong></td>' +
                                    '</tr>'
                                )
                            }
                        },
                        error: function(error) {
                            console.log(error);
                        }
                    })

                }
  function convertTo12HourFormat(dateTime) {
  const date = new Date(dateTime);
  const month = date.getMonth() + 1;
  const day = date.getDate();
  const year = date.getFullYear();
  const hours = date.getHours();
  const minutes = date.getMinutes();
  const amOrPm = hours >= 12 ? "PM" : "AM";
  const twelveHourFormatHours = hours % 12 || 12; // Convert 0 to 12

  const formattedDate = `${month}/${day}/${year}`;
  const formattedTime = `${twelveHourFormatHours}:${minutes.toString().padStart(2, '0')} ${amOrPm}`;

  return `${formattedDate} ${formattedTime}`;
}

                function updateClockinTime(obj) {
                    console.log(obj);

                    const dataArr = obj.split(',');

                    var time;
                    var date;
                    console.log(dataArr);
                    async function getUserEnteredTime() {
                        const dateTime2 = new Date(dataArr[0]);
                        const currentDateTime = new Date();
                        console.log(dateTime2);
                        const {
                            value: enteredTime
                        } = await Swal.fire({
                            title: 'Enter time',
                            html: `<input type="time" placeholder="HH/MM/PM" id="timeInput" step="2">`,
                            showCancelButton: true,
                            customClass: {
      container: 'custom-swal-container', // Add a custom class for the container
    },
                            backdrop: false,
                            confirmButtonText: 'Submit',
                            preConfirm: () => {
                                return new Promise((resolve) => {
                                    const enteredTime = document.getElementById('timeInput').value;
                                    const enteredTimeParts = enteredTime.split(':');
                                    debugger;
                                    const enteredHour = enteredTimeParts[0].padStart(2, '0'); // Ensure 2 digits for hours
                                    const enteredMinute = enteredTimeParts[1].padStart(2, '0');
                                    const newTime = `${enteredHour}:${enteredMinute}`;
                                    console.log(enteredTimeParts);
                                    time = newTime;
                                    const newDate = currentDateTime.toLocaleDateString();
                                    date = newDate;
                                    const enteredDateTimeStr =
                                        `${currentDateTime.toLocaleDateString()} ${enteredTime}`;
                                    const TimeToSubmit =
                                        `${currentDateTime.toLocaleDateString()} ${newTime}`;
                                    const enteredDateTime = new Date(enteredDateTimeStr);
                                    if (dataArr[3] === "clockin") {
                                        if (enteredDateTime >= dateTime2) {
                                            Swal.showValidationMessage(
                                                'Entered time must be less than clockout time.');
                                            resolve();
                                        } else {
                                            resolve(enteredTime);
                                            // console.log(TimeToSubmit, 'enteredDateTime');
                                            // debugger;

                                        }
                                    } else {
                                        if (enteredDateTime <= dateTime2) {
                                            Swal.showValidationMessage(
                                                'Entered time must be greater than clockin time.');
                                            resolve();
                                        } else {
                                            resolve(enteredTime);
                                            // console.log(TimeToSubmit, 'enteredDateTime');
                                            // debugger;

                                        }
                                    }

                                });
                            },
                        });

                        if (enteredTime) {
                            const arr = {
                                id: dataArr[1],
                                type: dataArr[3],
                                time: time,
                                date: date,
                                edit_employee: Employee_Name
                            }
                            // alert(arr);
                            $.ajax({
                                type: 'POST',
                                url: updateTime,
                                data: JSON.stringify(arr),
                                contentType: 'application/json',
                                dataType: 'JSON',
                                cache: false,
                                processData: false,
                                success: function(data) {
                                    if (data.status == "success") {
                                        Swal.fire(
                                                `Entered time:${enteredTime}`)
                                            .then(() => {
                                                location.reload();
                                            });
                                    } else {
                                        Swal.fire("Something went wrong!");
                                    }
                                }
                            });

                        }
                    }

                    // Call the async function to start the process
                    getUserEnteredTime();

                    // Call the async function to start the process
                    // getUserEnteredTime();



                }
                const NotePopup = (note) => {
                    console.log(note, "note");
                    const noteArr = note.split('/');

                    const {
                        // value: ""
                    } = Swal.fire({
                        title: 'Enter your text here',
                        input: 'textarea',
                        // input: 'text',
                        inputLabel: 'Note',
                        inputValue: "",
                        customClass: {
      container: 'custom-swal-container', // Add a custom class for the container
    },
                        backdrop: false,
                        showCancelButton: true,
                        inputValidator: (value) => {

                            if (!value) {
                                return 'You need to write something!'
                            } else {
                                data = {
                                    employee_id: noteArr[0],
                                    tc_id: noteArr[1],
                                    note: value
                                }
                                $.ajax({
                                    url: AddNoteUrl,
                                    type: "GET",
                                    data: data,
                                    success: function(data) {
                                        console.log(data);
                                        if (data.status == "success") {
                                    Swal.fire(
                                            'Good job!',
                                           'You clicked the button!',
                                            'success'
                                             )

                                            window.location.reload();
                                        } else {
                                            console.log("something went wrong")
                                        }
                                    }
                                })
                            }
                        }
                    })
                }
            </script>



</body>

</html>
<?php /**PATH /home/adihai1972/public_html/Panama_dup/timeclock/development/Test/resources/views/admin/confirmEmployeesListing.blade.php ENDPATH**/ ?>