
import os
from fastapi import FastAPI, UploadFile
from mangum import Mangum
import json
import requests
from pydantic import BaseModel

app = FastAPI()
handler = Mangum(app)

@app.get("/test")
def test_endpoint():
    return {"message": "API working!"}


@app.post("/upload_mp3")
async def upload_mp3(file: UploadFile):

    def query(file):
        headers = {
            "Authorization": f"Bearer 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"}
        API_URL = "https://api-inference.huggingface.co/models/facebook/wav2vec2-base-960h"

        try:
            data = file.file.read()
            response = requests.post(API_URL, headers=headers, files={
                "file": ("audio.mp3", data)})
            return json.loads(response.content.decode("utf-8"))

        except Exception as e:
            return {"error": str(e)}

    text_data = query(file)
    return text_data