<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Dry Clean Locker | Locations </title>

    <link href="<?php echo e(asset ('css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset ('font-awesome/css/font-awesome.css')); ?>" rel="stylesheet">

    <!-- FooTable -->
    <link href="<?php echo e(asset ('css/plugins/footable/footable.core.css')); ?>" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="<?php echo e(asset ('css/sweetalert.css')); ?>" rel="stylesheet">

    <link href="<?php echo e(asset ('css/animate.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset ('css/style.css')); ?>" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
</head>
<body>
    <div id="wrapper">

        <!-- Side Navbar -->
        <?php echo $__env->make('navbar_static_side', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?> 

        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <!-- Top Navbar -->
                <?php echo $__env->make('navbar_static_top', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?> 
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><strong>Locations</strong></h2>
                    <a href="<?php echo e(url('add_location')); ?>">
                        <button type="button" class="btn btn-default btn-sm">
                            <span class="glyphicon glyphicon-plus"></span> Add a Location
                        </button>
                    </a>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Shortcode</th>
                                            <th>Description</th>
                                            <th>Address Line 1</th>
                                            <th>Address Line 2</th>
                                            <th>City</th>
                                            <th>Country</th>
                                            <th>Postcode</th>
                                            <th>Access Notes</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody id="location_list">
                                       <!-- Dynamically appending Employees List -->
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="6">
                                                <ul class="pagination pull-right"></ul>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none"></button>
            <!-- Delete Row -->
            <button id="swal_btn2" type="button" style="display:none"></button>

            <!-- Footer -->
            <?php echo $__env->make('footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="deleteModal" role="dialog">
        <div class="modal-dialog">
          <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Delete Location</h4>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to delete the Location?</p>
                </div>
                <div class="modal-footer">
                     <button type="button" class="btn btn-default" style="background-color: #1ab394; color: white" onclick="deleteLocation()">Yes</button>
                    <button type="button" class="btn btn-default" style="background-color: #ed5565; color: white" data-dismiss="modal">No</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal Close -->



    <!-- Mainly scripts -->
    <script src="<?php echo e(asset ('js/jquery-3.1.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset ('js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset ('js/plugins/metisMenu/jquery.metisMenu.js')); ?>"></script>
    <script src="<?php echo e(asset ('js/plugins/slimscroll/jquery.slimscroll.min.js')); ?>"></script>

    <!-- Custom and plugin javascript -->
    <script src="<?php echo e(asset ('js/inspinia.js')); ?>"></script>
    <script src="<?php echo e(asset ('js/plugins/pace/pace.min.js')); ?>"></script>

    <!-- Sweet alert -->
    <script src="<?php echo e(asset ('js/plugins/sweetalert/sweetalert.min.js')); ?>"></script>

    <!-- FooTable -->
    <script src="<?php echo e(asset ('js/plugins/footable/footable.all.min.js')); ?>"></script>

    <!-- Page-Level Scripts -->
    <script>
        var delete_location;

        $(document).ready(function() 
        {
            $("#side2").addClass("activeSM");
            $("#side2 a").css("color","#224ea6");

            viewLocations();

            //Empty List
            $('#swal_btn').click(function(){
                swal({
                     title: "List is Empty!",
                    text: "Please add a location.",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                    closeOnConfirm: false
                }, function () {
                    window.location.assign("<?php echo e(url('add_location')); ?>");
                });
            });

            //Delete Row
            $('#swal_btn2').click(function(){
                swal({
                    title: "Location Deleted!",
                    text: "",
                    type: "success",
                    confirmButtonColor: "#DD6B55",
                });
            });
        });

        function viewLocations()
        {
            var $list = $("#location_list");
            $list.empty();
            $.ajax({
                url: "/DCL/api/LocationView",
                type: "POST",
                success: function(data)
                {   
                    var count = 1;
                    if ( data.status == "success")
                    {
                        $.each(data.data, function(index,obj) 
                        {
                            $list.append('<tr>'+
                                            '<td><strong>'+count+'</strong></td>'+
                                            '<td>'+obj.Shortcode+'</td>'+
                                            '<td>'+obj.Description+'</td>'+
                                            '<td>'+obj.AddressLine1+'</td>'+
                                            '<td>'+obj.AddressLine2+'</td>'+
                                            '<td>'+obj.City+'</td>'+
                                            '<td>'+obj.CountryID+'</td>'+
                                            '<td>'+obj.Postcode+'</td>'+
                                            '<td>'+obj.AccessNotes+'</td>'+
                                            '<td>'+
                                                '<div class="btn-group">'+
                                                    '<button id="'+obj.LocationID+'" onclick ="saveLocation(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/edit_icon.png" /></button>'+

                                                    '<button id="'+obj.LocationID+'" onclick ="deleteLocationModal(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/delete_icon.png" /></button>'+
                                                '</div>'+
                                            '</td>'+
                                        '</tr>');
                            count++;
                        });
                    }
                    else
                    {
                        swal_btn.click();
                    }
                },
                error: function(data)
                {
                }           
            });        
        }

        function deleteLocationModal(id)
        {
            $('#deleteModal').modal('show');
            delete_location = id;
        }


        function deleteLocation()
        {
            $('#deleteModal').modal('hide');

            var LocationID = delete_location;
            $.ajax({            
                url: "/DCL/api/LocationDelete",
                type: "post",
                data: {"LocationID": LocationID},
                success: function(data)
                {
                    if(data.status == "success")
                    {
                        swal_btn2.click();
                        viewLocations();
                    }
                    else if (data.status == "failed")
                    {
                        alert("failed");
                    }
                },
                error: function(data) 
                {
                }           
            });
        }

        function saveLocation(id)
        {
            var location_id = id;
            localStorage.setItem("location_id",location_id);
            window.location.href = "<?php echo e(url('edit_location')); ?>";
            
        }
    </script>
</body>
</html>
