<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\http\Request;
use Illuminate\http\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Input;
use Hash;


use DB;


class CategoryController extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;
	
    public function AddCategory (Request $request)
    { 
		if(isset($request['Name']) && !empty($request['Name'])) 
			{
			    
			    
				$Name=$request['Name'];
				$Name_Ar=$request['Name_Ar'];
				
				
			
				
				try 
				{ 
					$inserteed = DB::insert('insert into law_categories (category_name,category_arabic) values (?,?)',[$Name,$Name_Ar]);											  
					return response()->json(['status'=>'success']);   
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'Category Already Exist']);
				}

			}

		else 
			{
				return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
			}
      
    }
	
	
	
	
	public function CategoryEdit (Request $request)
    { 
			if(isset($request['CategoryID']) && !empty($request['CategoryID']) AND isset($request['Name']) && !empty($request['Name']) AND isset($request['Description']) && !empty($request['Description'])) 
			{
				$Name=$request['Name'];
				$CategoryID=$request['CategoryID'];
				$Description=$request['Description'];
				

				$users = DB::select('select * from Category where CategoryID = ?', [$CategoryID]);
				if($users)
				{
					try 
					{ 
						$user_new = DB::update('update Category SET Name = ? , Description = ? where CategoryID = ?', [$Name,$Description,$CategoryID]);
						if ( $user_new)                             
						{
							return response()->json(['status'=>'success']);
						}
						else 
						{
							return response()->json(['status'=>'failed','error'=>'Category Already Exist']);
						}
					
					}
					
					catch(\Illuminate\Database\QueryException $ex)
					{ 		
						return response()->json(['status'=>'failed','error'=>'Category Already Exist']);
					}
					
									  
					//return response()->json(['status'=>'success','data'=>$users ]);
				}
				else
				{
					return response()->json(['status'=>'failed','error'=>'Wrong Category Id']);
				}	
					  
				
			
			}

		else 
			{
				return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
			}
      
    }

public function CategoryView (Request $request)
    {

		if(isset($request['category_id']) && !empty($request['category_id'])) 
			{
				$category_id=$request['category_id'];
				
			$users = DB::select('select * from law_categories where category_id = ?', [$category_id]);
				if($users)
				{
					return response()->json(['status'=>'success','data'=>$users]);
				}
				else 
				{
					return response()->json(['status'=>'failed','error'=>'No Information Found']);
				}
			
		}
		else 
		{
			
		
			$users = DB::select('select * from law_categories');
			
				if($users)
				{
					return response()->json(['status'=>'success','data'=>$users]);
				}
				else 
				{
					return response()->json(['status'=>'failed','error'=>'No Information Found']);
				}
			
		}
        
    }
	
	
	public function CategoryDelete(Request $request)
    {
		if(isset($request['category_id']) && !empty($request['category_id'])) 
			{
				$CategoryID=$request['category_id'];
			
			
			$users = DB::select('select * from law_categories where category_id = ? ', [$CategoryID]);
			
				if($users)
				{
					try 
					{ 
					    $users = DB::delete('DELETE  from law_categories where category_id = ? ', [$CategoryID]);
					
                        if($users)
        				{
        					return response()->json(['status'=>'success']);
        				}
        				else 
        				{
        					return response()->json(['status'=>'failed','error'=>'Sql Error']);
        				}
					
					}
					
					catch(\Illuminate\Database\QueryException $ex)
					{ 		
						return response()->json(['status'=>'failed','error'=>'Sql Error']);
					}
				}
				else 
				{
					return response()->json(['status'=>'failed','error'=>'Wrong Category Id']);
				}
			
		}
		else 
		{
			return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
			
		}
        
    }

}

