<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>King Of Scooters | Employee</title>

    <?php echo $__env->make('partials.headerLinks', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <style type="text/css">
        .activeSM {
            background-color: white !important;
            /* #38283c !important;*/
        }

        .mystyle {
            background-color: white;
            border-color: greenyellow;
            color: #000;
        }

        .default {
            background-color: #224ea6;
            border-color: #224ea6;
            color: white;
        }
    </style>
    <script>
        const loginUrl = "<?php echo e(route('login')); ?>";

        if (!localStorage.login_timeclock_admin) {
            window.stop();
            window.location.replace(loginUrl);
        }
    </script>
</head>
 
<body>
    <div id="wrapper">
        <?php echo $__env->make('partials.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php echo $__env->make('partials.top-bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><strong>Who is on the clock</strong></h2>
                    
                </div>
                <div class="col-lg-10">
                    <h4 id="LocationName">

                    </h4>
                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="row">
                    <div class="col-lg-12">
                        <ul class="row" style="padding-right:20px">
                            <div class="col-sm-6">
                                <div>
                                    <li id="lastweek" onclick="ActiveThis2();"
                                        style="width: 100%; height: 40px; border-style: solid;font-size: 20px; margin-bottom : 20px"
                                        class="btn btn-primary m-t-n-xs mystyle">
                                        On the clock only
                                    </li>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div>
                                    <li id="thisweek" onclick="ActiveThis();"
                                        style="width: 100%; height: 40px; border-style: solid;font-size: 20px; margin-bottom : 20px"
                                        class="btn btn-primary m-t-n-xs default">
                                        Today's clock in/clock out
                                    </li>
                                </div>
                            </div>

                        </ul>
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                <table class="table table-striped" id="table1">
                                    <thead>
                                        <tr>
                                            <th colspan="5">Name</th>
                                            <th colspan="5">Date</th>
                                            <th colspan="5">Location</th>
                                            <th colspan="5">Position</th>
                                            <th colspan="5">In</th>
                                            <th colspan="5">Out</th>
                                            
                                            <th colspan="5">Total hr for paycheck</th>

                                        </tr>
                                    </thead>
                                    <tbody id="employee_list">


                                        <!-- Dynamically appending Employees List -->
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="6">
                                                <ul class="pagination pull-right">
                                                </ul>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                                <table class="table table-striped" hidden="true" id="table2">
                                    <thead>
                                        <tr>
                                            <th colspan="5">Name</th>
                                            <th colspan="5">Date</th>
                                            <th colspan="5">Location</th>
                                            <th colspan="5">Position</th>
                                            <th colspan="5">In</th>
                                            <th colspan="5">Out</th>
                                            
                                            <th colspan="5">Total hr for paycheck</th>

                                        </tr>
                                    </thead>
                                    <tbody id="employee_list2">
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="6">
                                                <ul class="pagination pull-right">
                                                </ul>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none"></button>
            <!-- Delete Row -->
            <button id="swal_btn2" type="button" style="display:none"></button>
            <!-- Active/Inactive row -->
            <button id="swal_btn3" type="button" style="display:none"></button>

        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="deleteModal" role="dialog">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Delete Employee</h4>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to delete the Employee?</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" style="background-color: #1ab394; color: white"
                        onclick="deleteEmployee()">Yes</button>
                    <button type="button" class="btn btn-default" style="background-color: #ed5565; color: white"
                        data-dismiss="modal">No</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal Close -->



    <!-- Mainly scripts -->
    <!-- Mainly scripts -->
    <?php echo $__env->make('partials.scriptLinks', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Page-Level Scripts -->
    <script>
        const ViewLocationUrl = "<?php echo e(route('allocationsactive')); ?>";
        const ViewEmployeesOnClock = "<?php echo e(route('ViewOnClockEmployees')); ?>";

        const date = new Date();
        let LocationName;
        const arrayOfDate = [];
        var clockTime = 0;
        const result2 = new Date().toLocaleString('en-GB', {
            hour12: false,
        });
        var currentLocation = localStorage.getItem('onTheClock');
        var currentLocationName = localStorage.getItem('onTheClockName');
        if (currentLocationName) {
            $('#LocationName').text(`Location: ${currentLocationName}`)
        }

        function calculateHours(object) {
            // console.log(object);
            var hours;

            if (object.clock_out == 0) {
                hours = parseFloat(object.working_hours);
                // console.log(hours);
                if (object.breaks) {
                    var tempStartDate;
                    $.each(object.breaks, function(index, obj) {
                        if (obj.back_to_work_date) {
                            tempStartDate = obj.back_to_work_date + " " + obj.back_to_work_time;
                        } else {
                            tempStartDate = obj.back_to_work_date;
                        }
                    });

                    if (tempStartDate) {
                        var startDate = new Date(tempStartDate);
                        var endDate = new Date();
                        var seconds = (endDate.getTime() - startDate.getTime()) / 1000;
                        hours = parseFloat(hours) + parseFloat(seconds);
                    } else {
                        hours = parseFloat(hours);
                    }
                } else {
                    var startDate = new Date(object.clock_in);
                    var endDate = new Date();
                    var seconds = (endDate.getTime() - startDate.getTime()) / 1000;
                    hours = parseFloat(seconds);
                }
            } else {
                hours = parseFloat(object.working_hours);
            }

            return hours;
        }
        console.log(currentLocation, "currentLocation");


        function secondsToHms(seconds) {
            seconds = Number(seconds);
            var h = Math.floor(seconds / 3600);
            var m = Math.floor(seconds % 3600 / 60);
            //var s = Math.floor(d % 3600 % 60);

            var hDisplay = h > 0 ? h + (h == 1 ? " Hour " : " Hours ") : "";
            var mDisplay = m > 0 ? m + (m == 1 ? " Minute " : " Minutes ") : "";
            //var sDisplay = s > 0 ? s + (s == 1 ? " second" : " seconds") : "";
            return hDisplay + mDisplay; // + sDisplay; 
        }
        const showEmployeesOnClock = (id) => {
            // console.log(id,"idsre")
            data = {
                location: id,
                employee_id: "All",
            }
            $.ajax({
                url: ViewEmployeesOnClock,
                type: "GET",
                data: data,
                success: function(data) {
                    // console.log(data.status);
                    if (data.status == 'success') {
                        // console.log(data.data.length, "data");
                        // debugger;

                        if (data.data.length >= 1) {
                            //  isAvail = 1;
                            var isAvail = 0;
                            console.log(data.data);
                            data.data.forEach(element => {
                                if (element.clock_out == 0) {
                                    //  isAvail = 1;
                                    // console.log("inside", element.employee_details);
                                    // if(element.employee_details.emp_status){
                                    if (element.employee_details) {
                                        isAvail = 1;
                                        console.log(element.clock_in, "clock_in");
                                        const dataClockin = element.clock_in.split(" ");
                                        const clock_inTime = dataClockin[1];
                                        console.log(dataClockin, 'dataClockin');
                                        const arrayOfObjects = element.breaks;
                                        const valueOFhours = calculateHours(element);
                                        var displayTime = secondsToHms(valueOFhours);
                                        var name = element.employee_details[0].emp_fname + " " +
                                            element.employee_details[0].emp_lname;

                                        var parent = $('#employee_list');
                                        parent.append(
                                            '<tr id="' + element.employee_id + '/' + element
                                            .location + '/' + element.tc_id +
                                            '" onclick="viewWhoDetails(this.id);">' +
                                            '<td colspan="5">' + name + '</td>' +
                                            '<td colspan="5">' + element.date + '</td>' +
                                            '<td colspan="5">' + element.location +
                                            '</td>' +
                                            '<td colspan="5">' + element.position +
                                            '</td>' +
                                            '<td colspan="5">' + clock_inTime +
                                            '</td>' +
                                            '<td colspan="5"></td>' +
                                            '<td colspan="5">' + displayTime + '</td>' +
                                            '</tr>'
                                        )

                                    }

                                    // }else{
                                    // console.log("not append")
                                    // }
                                }
                            });
                            if (isAvail == 0 && currentLocation !== "All") {
                                var parent = $('#employee_list');
                                parent.append(
                                    '<tr>' +
                                    '<td colspan="5" style="color:red;font-size: 20px;background:#fff;"><strong>No Result Found.</strong></td>' +
                                    '</tr>'
                                )
                            } else {
                                console.log("no list");
                            }
                        }

                    } else {
                        var parent = $('#employee_list');
                        parent.append(
                            '<tr>' +
                            '<td colspan="5" style="color:red;font-size: 20px;background:#fff;"><strong>No Result Found.</strong></td>' +
                            '</tr>'
                        )

                    }
                    // var dat = data;
                },
                error: function(data) {


                }
            })
        }
        const getAllLocation = () => {
            $.ajax({
                url: ViewLocationUrl,
                type: "GET",
                success: function(data) {
                    // console.log(data);
                    var dat = data;

                    if (dat.status == "success") {
                        // console.log(dat.Data, "data");
                        dat.Data.forEach(element => {
                            if (element.location_id == currentLocation) {
                                // console.log(element.location_id, element.location_name);
                                LocationName = element.location_name;
                                showEmployeesOnClock(element.location_name);
                            } else {
                                console.log("no location found")
                            }
                        });
                    } else {
                        // alert("error");
                    }
                    // $(".overlay").hide();
                },
                error: function(data) {
                    // $(".overlay").hide();
                    // alert("error");
                }
            });
        }
        const viewWhoDetails = (obj) => {
            // console.log(obj);
            const sliptedArray = obj.split('/');
            const data = {
                employee_id: sliptedArray[0],
                location: sliptedArray[1]
            }
            $.ajax({
                url: ViewEmployeesOnClock,
                type: "GET",
                data: data,
                success: function(data) {
                    // console.log(data);
                    if (data.status == 'success') {
                        if (data.data.length > 0) {
                            const index = data.data.findIndex(object => {
                                return object.tc_id == sliptedArray[2];
                            });
                            // console.log(index, sliptedArray[2]);
                            var EmployeeData = data.data;
                            // console.log(EmployeeData, 'EmployeeData');
                            localStorage.EmployeesObject = JSON.stringify(data.data);
                            localStorage.Employee_Tc_Id = sliptedArray[2];
                            window.location.href = "/manage-admin/employee-clockin";
                        }
                    }
                },
                error: function(error) {
                    console.log(error);
                }
            })
        }
        const viewWhoDetails2 = (obj) => {
            // console.log(obj);
            const sliptedArray = obj.split('/');
            const data = {
                employee_id: sliptedArray[0],
                location: sliptedArray[1]
            }
            $.ajax({
                url: ViewEmployeesOnClock,
                type: "GET",
                data: data,
                success: function(data) {
                    // console.log(data);
                    if (data.status == 'success') {
                        if (data.data.length > 0) {
                            const index = data.data.findIndex(object => {
                                return object.tc_id == sliptedArray[2];
                            });
                            // console.log(index, sliptedArray[2]);
                            var EmployeeData = data.data;
                            // console.log(EmployeeData, 'EmployeeData');
                            localStorage.EmployeesObject = JSON.stringify(data.data);
                            localStorage.Employee_Tc_Id = sliptedArray[2];
                            window.location.href = "/manage-admin/todays-clockin";
                        }
                    }
                },
                error: function(error) {
                    console.log(error);
                }
            })
        }
        const getCalledAgain = () => {
            if (currentLocation == "All") {
                showEmployeesOnClock(currentLocation);
            } else {
                getAllLocation();
            }
        }

        const ShowTodaysClock = () => {
            const today = new Date();
            const yyyy = today.getFullYear();
            let mm = today.getMonth() + 1; // Months start at 0!
            let dd = today.getDate();

            if (dd < 10) dd = '0' + dd;
            if (mm < 10) mm = '0' + mm;

            const formattedToday = mm + '/' + dd + '/' + yyyy;
            // console.log(formattedToday, "formattedToday")
            // document.getElementById('DATE').value = formattedToday;
            data = {
                location: LocationName,
                employee_id: "All",
            }
            // console.log(dateNow, currentLocation, "tw");
            $.ajax({
                url: ViewEmployeesOnClock,
                type: "GET",
                data: data,
                success: function(data) {
                    // console.log(data.status);
                    if (data.status == 'success') {
                        // console.log(data.data, "data");
                        // debugger;

                        if (data.data.length >= 1) {
                            //  isAvail = 1;
                            var isAvail = 0;
                            data.data.forEach(element => {
                                console.log(element.date == '09/19/2023');
                                if (element.date == '09/19/2023') {
                                    // console.log("insideOfLopp");

                                    //  isAvail = 1;
                                    // console.log("inside", element.employee_details);
                                    // if(element.employee_details.emp_status){
                                    if (element.employee_details) {
                                        // console.log("insideOfLopp2");

                                        isAvail = 1;
                                        // console.log('inside');
                                        // console.log('inside2');
                                        const arrayOfObjects = element.breaks;
                                        const valueOFhours = calculateHours(element);
                                        var displayTime = secondsToHms(valueOFhours);
                                        const dataClockin = element.clock_in.split(" ");
                                        const clock_inTime = dataClockin[1];
                                        let clockOutTime;
                                        if (element.clock_out != 0 && element.clock_out != null &&
                                            element.clock_out != "") {
                                            // console.log(element.clock_out,"insideTime");\
                                            const dataClockin = element.clock_out.split(" ");
                                            clockOutTime = dataClockin[1];
                                        } else {
                                            clockOutTime = "";
                                        }
                                        console.log(dataClockin, 'dataClockin');
                                        // console.log(displayTime);
                                        // console.log(valueOFhours, 'valueOFhours')
                                        var name = element.employee_details[0].emp_fname + " " +
                                            element.employee_details[0].emp_lname;

                                        var parent = $('#employee_list2');
                                        parent.append(
                                            '<tr id="' + element.employee_id + '/' + element
                                            .location + '/' + element.tc_id +
                                            '" onclick="viewWhoDetails2(this.id);">' +
                                            '<td colspan="5">' + name + '</td>' +
                                            '<td colspan="5">' + element.date + '</td>' +
                                            '<td colspan="5">' + element.location +
                                            '</td>' +
                                            '<td colspan="5">' + element.position +
                                            '</td>' +
                                            '<td colspan="5">' + clock_inTime +
                                            '</td>' +
                                            '<td colspan="5">' + clockOutTime + '</td>' +
                                            '<td colspan="5">' + displayTime + '</td>' +
                                            '</tr>'
                                        )

                                    }

                                    // }else{
                                    // console.log("not append")
                                    // }
                                }
                            });
                            if (isAvail == 0 && currentLocation !== "All") {
                                var parent = $('#employee_list2');
                                parent.append(
                                    '<tr>' +
                                    '<td colspan="5" style="color:red;font-size: 20px;background:#fff;"><strong>No Result Found.</strong></td>' +
                                    '</tr>'
                                )
                            } else {
                                console.log("no list");
                            }
                        } else {
                            var parent = $('#employee_list2');
                            parent.append(
                                '<tr>' +
                                '<td colspan="5" style="color:red;font-size: 20px;background:#fff;"><strong>No Result Found.</strong></td>' +
                                '</tr>'
                            )


                        }

                    } else {

                        var parent = $('#employee_list2');
                        parent.append(
                            '<tr>' +
                            '<td colspan="5" style="color:red;font-size: 20px;background:#fff;"><strong>No Result Found.</strong></td>' +
                            '</tr>'
                        )

                    }
                    // var dat = data;
                },
                error: function(data) {


                }
            })
        }
        if (currentLocation == "All") {
            showEmployeesOnClock(currentLocation);
        } else {
            getAllLocation();

        }
        // ShowTodaysClock();

        const ActiveThis2 = () => {
            var List = document.getElementById('table1');
            var List2 = document.getElementById('table2');
            var elem = document.getElementById('lastweek');
            var elem1 = document.getElementById('thisweek');
            // var tabletbody = document.getElementById('')
            elem.classList.remove("default");
            elem.classList.add("mystyle");
            elem1.classList.remove("mystyle");
            elem1.classList.add("default");
            // console.log(List);
            List2.setAttribute('hidden', true);
            List.removeAttribute("hidden");

        }
        let isFirstCall = true;

        const ActiveThis = () => {
            if (isFirstCall) {
                ShowTodaysClock(); // Call ShowTodaysClock only on the first call
                isFirstCall = false; // Set the flag to false to prevent future calls
            }

            // Rest of your code
            var List = document.getElementById('table1');
            var List2 = document.getElementById('table2');
            var elem = document.getElementById('thisweek');
            var elem1 = document.getElementById('lastweek');
            elem.classList.remove("default");
            elem.classList.add("mystyle");
            elem1.classList.remove("mystyle");
            elem1.classList.add("default");
            List.setAttribute("hidden", true);
            List2.removeAttribute("hidden");
        }

        // const allocationsactive
    </script>
</body>

</html>
<?php /**PATH E:\laragon\www\Time-Clock\resources\views/admin/show-location-list.blade.php ENDPATH**/ ?>