<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Timeclock Admin Panel | Clock Out An Employee</title>

    @include('partials.headerLinks')
    <style type="text/css">
        .activeSM {
            background-color: white !important;
            /* #38283c !important;*/
        }

        #loading-img {
            background: url(img/load.gif) center center no-repeat;
            height: 100%;
            z-index: 20;
        }

        .overlay {
            background: #e9e9e9;
            display: none;
            position: absolute;
            top: -100px;
            right: -100px;
            bottom: 0;
            left: 0;
            height: 900px;
            opacity: 0.5;
            z-index: 999;
        }
    </style>
    <script>
        const loginUrl = "{{ route('login') }}";

        if (!localStorage.login_timeclock_admin) {
            window.stop();
            window.location.replace(loginUrl);
        }
    </script>
</head>

<body>
    <div id="wrapper">
        @include('partials.navbar')
        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                @include('partials.top-bar')
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><strong>Clock out an Employee</strong></h2>
                </div>
                <div class="col-lg-2">
                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="container">

                    <div class="row">
                        <div class="col-sm-4" style="padding:0">
                            <h2><strong>Choose an Employee</strong></h2>
                            <input type="text" class="form-control" id="search_name" name="search_name"
                                placeholder="Search by Name" onkeyup="searchFilter()">
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                <table class="footable table table-stripped toggle-arrow-tiny" data-page-size="15">
                                    <thead>
                                        <tr>
                                            <th>Name</th>
                                            <th>Location</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody id="employee_list">
                                        <!-- Dynamically appending Locations List -->
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>


            </div>


            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none">
                <!-- Delete Row -->
                <button id="swal_btn2" type="button" style="display:none">
                    <!-- Active/Inactive row -->
                    <button id="swal_btn3" type="button" style="display:none">
        </div>
    </div>

    <!-- Image Loader -->
    <div class="overlay">
        <div id="loading-img"></div>
    </div>
    <!-- Image Loader END -->

    <!-- Mainly scripts -->
    @include('partials.scriptLinks')


    <!-- Page-Level Scripts -->
    <script>
        var employeesObject;

        $(document).ready(function() {
            $('#emp_name').html(localStorage.Employee_Name);

            $("#side3").addClass("activeSM");
            $("#side3 a").css("color", "#224ea6");

            ViewClockedInEmployees();
        });

        function ViewClockedInEmployees() {
            var $list = $('#employee_list');
            $list.empty();

            $.ajax({
                url: "http://127.0.0.1:9000/api/ViewClockedInEmployees",
                type: "GET",
                data: {
                    "location": "All"
                },
                success: function(data) {
                    if (data.status == "success") {
                        employeesObject = data.data;

                        $.each(data.data, function(index, obj) {
                            $.each(obj.employee_details, function(index2, obj2) {
                                console.log(obj.employee_details, "detials");
                                $list.append('<tr>' +
                                    '<td>' + obj2.emp_fname + ' ' + obj2.emp_lname +
                                    '</td>' +
                                    '<td>' + obj.location + '</td>' +
                                    '<td>' +
                                    '<div class="btn-group">' +
                                    '<button id="' + obj.tc_id + '_' + obj.location + '_' +
                                    obj.employee_id +
                                    '" style="background-color: #224ea6;border-color: #224ea6;color: white;" onclick ="apiCall(this.id);" class="ladda-button ladda-button-demo detailsBtn btn-primary btn btn-xs" type="submit" data-style="zoom-in">' +
                                    '<span class="ladda-label">View Details</span><span class="ladda-spinner"></span>' +
                                    '</button>' +
                                    '</div>' +
                                    '</td>' +
                                    '</tr>');
                            });
                        });
                    } else if (data.status == "failed") {
                        alert(data.error);
                    }
                },
                error: function(data) {
                    alert("error");
                }
            });
        }

        function apiCall(id) {
            $(".overlay").show();

            var temp = id.split('_');

            $.ajax({
                url: "http://127.0.0.1:9000/api/ViewOnClockEmployees",
                type: "GET",
                data: {
                    "location": temp[1],
                    "employee_id": temp[2]
                },
                success: function(data) {
                    if (data.status == "success") {
                        console.log(data.data);
                        $(".overlay").hide();
                        localStorage.EmployeesObject = JSON.stringify(data.data);
                        localStorage.Employee_Tc_Id = temp[0];
                        window.location.href = "/manage-admin/clockout-details";
                    } else if (data.status == "failed") {
                        alert(data.error);
                    }
                },
                error: function(data) {
                    alert("error");
                }
            });
        }

        function searchFilter() {
            var $list = $('#employee_list');
            var substring = $('#search_name').val();

            substring = substring.toLowerCase();

            if (substring) {
                $list.empty();

                $.each(employeesObject, function(index, obj) {
                    $.each(obj.employee_details, function(index2, obj2) {
                        var string = obj2.emp_fname + ' ' + obj2.emp_lname;
                        string = string.toLowerCase();

                        if (string.includes(substring)) {
                            $list.append('<tr>' +
                                '<td>' + obj2.emp_fname + ' ' + obj2.emp_lname + '</td>' +
                                '<td>' + obj.location + '</td>' +
                                '<td>' +
                                '<div class="btn-group">' +
                                '<button id="' + obj.tc_id + '_' + obj.location + '_' + obj
                                .employee_id +
                                '" style="background-color: #224ea6;border-color: #224ea6;color: white;" onclick ="apiCall(this.id);" class="ladda-button ladda-button-demo detailsBtn btn-primary btn btn-xs" type="submit" data-style="zoom-in">' +
                                '<span class="ladda-label">View Details</span><span class="ladda-spinner"></span>' +
                                '</button>' +
                                '</div>' +
                                '</td>' +
                                '</tr>');
                        }
                    });
                });

            } else {
                $list.empty();

                $.each(employeesObject, function(index, obj) {
                    $.each(obj.employee_details, function(index2, obj2) {
                        $list.append('<tr>' +
                            '<td>' + obj2.emp_fname + ' ' + obj2.emp_lname + '</td>' +
                            '<td>' + obj.location + '</td>' +
                            '<td>' +
                            '<div class="btn-group">' +
                            '<button id="' + obj.tc_id + '_' + obj.location + '_' + obj.employee_id +
                            '" style="background-color: #224ea6;border-color: #224ea6;color: white;" onclick ="apiCall(this.id);" class="ladda-button ladda-button-demo detailsBtn btn-primary btn btn-xs" type="submit" data-style="zoom-in">' +
                            '<span class="ladda-label">View Details</span><span class="ladda-spinner"></span>' +
                            '</button>' +
                            '</div>' +
                            '</td>' +
                            '</tr>');
                    });
                });
            }
        }
    </script>
</body>

</html>
