<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\http\Request;
use Illuminate\http\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Input;
use Hash;


use DB;


class ItemsController extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;
	
    public function AddItem (Request $request)
    { 
		if( isset($request['price']) && !empty($request['price'])
			AND isset($request['quantity_avail']) && !empty($request['quantity_avail'])
			AND isset($request['law_category']) && !empty($request['law_category'])) 
			{
				$name_english=$request['name_english'];
				$name_arabic=$request['name_arabic'];
				$description_english=$request['description_english'];
				$description_arabic=$request['description_arabic'];
				
				$price=$request['price'];
				$quantity_avail =$request['quantity_avail'];
				$law_category =$request['law_category'];
				
				$request->file('photo');
				 $destinationPath='public/Maktabi_Items';
				 $file=$request->photo;
				 $extention=$request->photo->extension();
			//  $extention=$file->getClientOriginalExtention();
				 $fileName=round(microtime(true)).".".$extention;
				 $file->move($destinationPath,$fileName);
				 $photo=$fileName;
				 $destination = "Maktabi_Items/";
				 $target_file = $destination. $photo;
				 //return  $photo;
				 
				 $bk_id= mt_rand();
				 
				try 
				{ 
					$inserteed = DB::insert('insert into maktabti_books (book_id,name_english,name_arabic,description_english,description_arabic,price,quantity_avail,law_category,cover_photo) 
					values (?,?,?,?,?,?,?,?,?)',[$bk_id,$name_english,$name_arabic,$description_english,$description_arabic,$price,$quantity_avail,$law_category,$target_file]);											  
					return response()->json(['status'=>'success','book_id'=>$bk_id]);   
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'Item Already Exist']);
				}
				

			}

		else 
			{
				return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
			}
      
    }
	
	
	 public function BooksImages (Request $request)
    { 
		if ( isset($request['book_id']) && !empty($request['book_id'])) 
			{
				$book_id =$request['book_id'];
				
				
				$request->file('photo');
				 $destinationPath='public/Maktabi_Items';
				 $file=$request->photo;
				 $extention=$request->photo->extension();
			//  $extention=$file->getClientOriginalExtention();
				 $fileName=round(microtime(true)).".".$extention;
				 $file->move($destinationPath,$fileName);
				 $photo=$fileName;
				 $destination = "Maktabi_Items/";
				 $target_file = $destination. $photo;
				 //return  $photo;
				try 
				{ 
					$inserteed = DB::insert('insert into book_images (book_id,image) 
					values (?,?)',[$book_id,$target_file]);											  
					return response()->json(['status'=>'success']);   
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'Book does not exists']);
				}
				

			}

		else 
			{
				return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
			}
      
    }

public function BooksImagesEdit (Request $request)
    { 
		if ( isset($request['img_id']) && !empty($request['img_id'])) 
			{
				$img_id=$request['img_id'];
				
				
				$request->file('photo');
				 $destinationPath='public/Maktabi_Items';
				 $file=$request->photo;
				 $extention=$request->photo->extension();
			//  $extention=$file->getClientOriginalExtention();
				 $fileName=round(microtime(true)).".".$extention;
				 $file->move($destinationPath,$fileName);
				 $photo=$fileName;
				 $destination = "Maktabi_Items/";
				 $target_file = $destination. $photo;
				 //return  $photo;
				try 
				{ 
                                            $user_new = DB::update('update book_images SET image = ? where bk_im_id= ?', [$target_file,$img_id]);
							if ( $user_new)                             
							{
								return response()->json(['status'=>'success']);
							}
							else 
							{
								return response()->json(['status'=>'failed','error'=>'Item Already Exist']);
							}

					
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'Book does not exists']);
				}
				

			}

		else 
			{
				return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
			}
      
    }
	

public function BooksImagesDelete (Request $request)
    { 
		if ( isset($request['img_id']) && !empty($request['img_id'])) 
			{
				
                                         $img_id=$request['img_id']; 
					$users = DB::delete('DELETE  from book_images where bk_im_id= ? ', [$img_id]);
					
	                                        if($users)
	        				{
	        					return response()->json(['status'=>'success']);
	        				}
	        				else 
	        				{
	        					return response()->json(['status'=>'failed','error'=>'Sql Error']);
	        				}
				
				

			}

		else 
			{
				return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
			}
      
    }
	
	
	
	public function ItemEdit (Request $request)
    { 
			if(isset($request['book_id']) && !empty($request['book_id'])) 
			{
				$name_english=$request['name_english'];
				$name_arabic=$request['name_arabic'];
				$description_english=$request['description_english'];
				$description_arabic=$request['description_arabic'];
				
				$price=$request['price'];
				$quantity_avail =$request['quantity_avail'];
				$law_category =$request['law_category'];
				$book_id =$request['book_id'];
				
				if(isset($request['photo']) && !empty($request['photo']))
				{
				
				 $request->file('photo');
				 $destinationPath='public/DCL_Items';
				 $file=$request->photo;
				 $extention=$request->photo->extension();
			    //  $extention=$file->getClientOriginalExtention();
				 $fileName=round(microtime(true)).".".$extention;
				 $file->move($destinationPath,$fileName);
				 $photo=$fileName;
                 $destination = "DCL_Items/";
				 $target_file = $destination. $photo;
				 //return $target_file;
				 
					$users = DB::select('select * from maktabti_books where book_id = ?', [$book_id]);
					if($users)
					{
						try 
						{ 
							$user_new = DB::update('update maktabti_books SET name_english = ? , name_arabic = ? , description_english = ?, description_arabic = ?, price = ? , quantity_avail=?, law_category=? ,cover_photo=? where book_id = ?', [$name_english,$name_arabic,$description_english,$description_arabic,$price,$quantity_avail,$law_category,$target_file,$book_id]);
							if ( $user_new)                             
							{
								return response()->json(['status'=>'success']);
							}
							else 
							{
								return response()->json(['status'=>'failed','error'=>'Item Already Exist']);
							}
						
						}
						
						catch(\Illuminate\Database\QueryException $ex)
						{ 		
							return response()->json(['status'=>'failed','error'=>'Item Already Exist']);
						}
						
										  
						//return response()->json(['status'=>'success','data'=>$users ]);
					}
					else
					{
						return response()->json(['status'=>'failed','error'=>'Wrong Item Id']);
					}
				 
				 
				 
				}
				else 
				{
					$users = DB::select('select * from maktabti_books where book_id = ?', [$book_id]);
					if($users)
					{
						try 
						{ 
							$user_new = DB::update('update maktabti_books SET name_english = ? , name_arabic = ? , description_english = ?, description_arabic = ?, price = ? , quantity_avail=?, law_category=?  where book_id = ?', [$name_english,$name_arabic,$description_english,$description_arabic,$price,$quantity_avail,$law_category,$book_id]);
							if ( $user_new)                             
							{
								return response()->json(['status'=>'success']);
							}
							else 
							{
								return response()->json(['status'=>'failed','error'=>'Item Already Exist']);
							}
						
						}
						
						catch(\Illuminate\Database\QueryException $ex)
						{ 		
							return response()->json(['status'=>'failed','error'=>'Item Already Exist']);
						}
						
										  
						//return response()->json(['status'=>'success','data'=>$users ]);
					}
					else
					{
						return response()->json(['status'=>'failed','error'=>'Wrong Item Id']);
					}	
				}
			}

		else 
			{
				return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
			}
      
    }

public function ItemView (Request $request)
    {

		if(isset($request['book_id']) && !empty($request['book_id'])) 
			{
				$book_id =$request['book_id'];
			
					$order = DB::select('select * from maktabti_books where book_id = ?', [$book_id]);
					if($order)
					{
					
						foreach ($order as $od)
						{
							$order_it= DB::select('select * from book_images where book_id = ?', [$book_id]);
							$od->images = $order_it;
						}
						
                    return response()->json(['status'=>'success','data'=>$order]);

					}
					else 
					{
						return response()->json(['status'=>'failed','error'=>'No Information Found']);
					}
			
		}
		else 
		{
			
	        	$order = DB::select('select * from maktabti_books');
					if($order)
					{
					
						foreach ($order as $od)
						{
						    $b_id = $od->book_id;
							$order_it= DB::select('select * from book_images where book_id = ?', [$b_id]);
							$od->images = $order_it;
						}
						
                    return response()->json(['status'=>'success','data'=>$order]);

					}
					else 
					{
						return response()->json(['status'=>'failed','error'=>'No Information Found']);
					}
			
		}
        
    }
	
	
	public function ItemDelete(Request $request)
    {
		if(isset($request['book_id']) && !empty($request['book_id'])) 
			{
				$book_id=$request['book_id'];
			
			
			$users = DB::select('select * from maktabti_books where book_id= ? ', [$book_id]);
			
				if($users)
				{
					try 
					{ 
					    $users = DB::delete('DELETE  from maktabti_books where book_id = ? ', [$book_id]);
					
	                                        if($users)
	        				{
	        					return response()->json(['status'=>'success']);
	        				}
	        				else 
	        				{
	        					return response()->json(['status'=>'failed','error'=>'Sql Error']);
	        				}
					
					}
					
					catch(\Illuminate\Database\QueryException $ex)
					{ 		
						return response()->json(['status'=>'failed','error'=>'Sql Error']);
					}
				}
				else 
				{
					return response()->json(['status'=>'failed','error'=>'Wrong Category Id']);
				}
			
		}
		else 
		{
			return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
			
		}
            
    }


public function ViewByType (Request $request)
    { 
		if(isset($request['type']) && !empty($request['type'])) 
			{
				$type=$request['type'];
				
				$low = "low";
				$high = "high";
				$newest = "newest";
				$trend = "trend";
				if(strcmp($type,$low)==0)
				{
					$order = DB::select('select * from maktabti_books Order By price ASC');
					if($order)
					{
						foreach ($order as $od)
						{
							$b_id = $od->book_id;
							$order_it= DB::select('select * from book_images where book_id = ?', [$b_id]);
							$od->images = $order_it;
						}
						
                    return response()->json(['status'=>'success','data'=>$order]);

					}
					else 
					{
						return response()->json(['status'=>'failed','error'=>'No Information Found']);
					}

				}
				
				else if(strcmp($type,$high)==0)
				{
					$order = DB::select('select * from maktabti_books Order By price DESC');
					if($order)
					{
						foreach ($order as $od)
						{
							$b_id = $od->book_id;
							$order_it= DB::select('select * from book_images where book_id = ?', [$b_id]);
							$od->images = $order_it;
						}
						
                    return response()->json(['status'=>'success','data'=>$order]);

					}
					else 
					{
						return response()->json(['status'=>'failed','error'=>'No Information Found']);
					}

				}
				
				else if(strcmp($type,$newest)==0)
				{
					
					$order = DB::select('select * from maktabti_books Order By added_attimes DESC');
						if($order)
						{
							foreach ($order as $od)
							{
								$b_id = $od->book_id;
								$order_it= DB::select('select * from book_images where book_id = ?', [$b_id]);
								$od->images = $order_it;
							}
							
						return response()->json(['status'=>'success','data'=>$order]);

						}
						else 
						{
							return response()->json(['status'=>'failed','error'=>'No Information Found']);
						}

				}
				
				
				else if(strcmp($type,$trend)==0)
				{
					
					$order = DB::select('select * from maktabti_books Order By books_sold DESC');
						if($order)
						{
							foreach ($order as $od)
							{
								$b_id = $od->book_id;
								$order_it= DB::select('select * from book_images where book_id = ?', [$b_id]);
								$od->images = $order_it;
							}
							
						return response()->json(['status'=>'success','data'=>$order]);

						}
						else 
						{
							return response()->json(['status'=>'failed','error'=>'No Information Found']);
						}

				}
				
				
				
				else 
				{
					return response()->json(['status'=>'failed','error'=>'No Information Found']);
				}
				

			}

		else 
			{
				return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
			}
      
    }

}

