<!DOCTYPE html>
<html>
<head>
  <title>Maktabti | Add Book </title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <link href="{{ asset ('css/bootstrap.min.css') }}" rel="stylesheet">
  <link href="{{ asset ('font-awesome/css/font-awesome.css') }}" rel="stylesheet">

  <!-- FooTable -->
  <link href="{{ asset ('css/plugins/footable/footable.core.css') }}" rel="stylesheet">

  <!-- Sweet Alert -->
  <link href="{{ asset ('css/sweetalert.css') }}" rel="stylesheet">

  <!-- Ladda style -->
  <link href="{{ asset ('css/ladda-themeless.min.css')}}" rel="stylesheet">

  <link href="{{ asset ('css/animate.css') }}" rel="stylesheet">
  <link href="{{ asset ('css/style.css') }}" rel="stylesheet">
  <style type="text/css">
  .activeSM
  {
    background-color: white !important; /* #38283c !important;*/
  }
</style>
<style>
article, aside, figure, footer, header, hgroup, 
menu, nav, section { display: block; }
</style>
<script>
  if (!localStorage.Session)
  {
    window.stop();
    window.location.replace("login");
  }
</script>
<style>
* {
  box-sizing: border-box;
}

body {
  background-color: #f1f1f1;
}

#regForm {
  background-color: #ffffff;
  margin: 100px auto;
  font-family: Raleway;
  padding: 40px;
  width: 70%;
  min-width: 300px;
}

h1 {
  text-align: center;  
}

input {
  padding: 10px;
  width: 100%;
  font-size: 17px;
  font-family: Raleway;
  border: 1px solid #aaaaaa;
}

/* Mark input boxes that gets an error on validation: */
input.invalid {
  background-color: #ffdddd;
}

/* Hide all steps by default: */

button {
  background-color: #4CAF50;
  color: #ffffff;
  border: none;
  padding: 10px 20px;
  font-size: 17px;
  font-family: Raleway;
  cursor: pointer;
}

button:hover {
  opacity: 0.8;
}

#prevBtn {
  background-color: #bbbbbb;
}

/* Make circles that indicate the steps of the form: */
.step {
  height: 15px;
  width: 15px;
  margin: 0 2px;
  background-color: #bbbbbb;
  border: none;  
  border-radius: 50%;
  display: inline-block;
  opacity: 0.5;
}

.step.active {
  opacity: 1;
}

/* Mark the steps that are finished and valid: */
.step.finish {
  background-color: #4CAF50;
}
</style>
</head>

<body>
  <div id="wrapper">
    @include('navbar_static_side')

    <div id="page-wrapper" class="gray-bg">
      <div class="row border-bottom">
        @include('navbar_static_top')
      </div>

      <div class="row wrapper border-bottom white-bg page-heading">
        <div class="col-lg-10">
          <h2><Strong>Add Book</Strong></h2>
          <ol class="breadcrumb">
            <li>
              <a href="{{ url('view_style')}}">Books</a>
            </li>
            <li class="active">
              <strong>Add Book</strong>
            </li>
          </ol>
        </div>
        <div class="col-lg-2">

        </div>
      </div>

      <div class="wrapper wrapper-content animated fadeInRight">
        <div class="row">
          <div class="col-lg-8">
            <div class="ibox ">
              <div class="ibox-content">
                <form id="regForm" style="display: block" >
                  <h1>Book Information:</h1> <br>
                  <!-- One "tab" for each step in the form: -->
                
                    <label>Category List</label>								
                    <select class="form-control" id="category_list" name="category_list" required="">
                   </select>
                   <br>

                   <label>Upload Cover Photo</label>
                   <input type="file" id="photo" name="photo" class="form-control"  onchange="readURL(this);" required>
                   <img id="blah" src="#" alt="your image" />
                   <br>

                   <label>Book Name (English)</label>
                   <input type="text" id="name_english" name="name_english" placeholder="Enter category name" class="form-control" required>
                   <br>

                   <label>Book Name (Arabic)</label>
                   <input type="text" id="name_arabic" name="name_arabic" placeholder="Enter category name" class="form-control" required>
                   <br>

                   <label>Unit Price</label>
                   <input type="text" id="price" name="price" placeholder="Enter category name" class="form-control" required>
                   <br>

                   <label>In Stock</label>
                   <input type="text" id="quantity_avail" name="quantity_avail" placeholder="Enter category name" class="form-control" required>
                   <br>

                   <label>Description (English)</label>
                   <textarea rows="5" id="description_english" name="description_english" placeholder="Enter Description" class="form-control" required></textarea>
                   <br>

                   <label>Description (Arabic)</label>
                   <textarea rows="5" id="description_arabic" name="description_arabic" placeholder="Enter Description" class="form-control" required></textarea>
                   <br>

                    <div>
                            <button style="background-color: #566b8a;color: white;" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                 <span class="ladda-label">Submit</span><span class="ladda-spinner"></span>
                            </button>
                        </div>

              </form>

              <form id="regForm2" style="display: none">
                  <h1>Book Images:</h1> <br>
                  <!-- One "tab" for each step in the form: -->
                
                    <div class="tab" >Books Images: <br>
                  <label>Upload Cover Photo</label>
                  <input type="file" id="photo" name="photo" class="form-control" required>
                </div>

<br>
<br>
                <div>
                            <button style="background-color: #566b8a;color: white;" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                 <span class="ladda-label">Add Picture</span><span class="ladda-spinner"></span>
                            </button>

                           <!--  <button style="background-color: #566b8a;color: white;" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                 <span class="ladda-label">Save</span><span class="ladda-spinner"></span>
                            </button>  -->

                        </div>

              </form>
              

                



            </div>
          </div>
        </div>
      </div>
    </div>
    @include('footer')
  </div>
</div>



<!-- Mainly scripts -->
<script src="js/jquery-3.1.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>

<!-- Custom and plugin javascript -->
<script src="js/inspinia.js"></script>
<script src="js/plugins/pace/pace.min.js"></script>

<script src="js/plugins/jquery-ui/jquery-ui.min.js"></script>

<!-- Sweet alert -->
<script src="js/plugins/sweetalert/sweetalert.min.js"></script>

<!-- Jquery Validate -->
<script src="js/plugins/validate/jquery.validate.min.js"></script>

<!-- Ladda -->
<script src="js/plugins/ladda/spin.min.js"></script>
<script src="js/plugins/ladda/ladda.min.js"></script>
<script src="js/plugins/ladda/ladda.jquery.min.js"></script>

<script>
  var errorMessage;
  var bk_id;
  $(document).ready(function()
  {
    viewCategories();
    $("#side7").addClass("activeSM");
    $("#side7 a").css("color","#224ea6");

    $("#regForm").validate({
      rules: 
      {
        photo: {
          required: true
        },
        name_english: {
          required: true,
        },
        name_arabic: {
          required: true,
        }
      },
      messages: 
      {
      },
      submitHandler: function(form) 
      {
        //var l = $( '.ladda-button-demo' ).ladda();
        //l.ladda( 'start' );
        var swal_btn = document.getElementById("swal_btn");

        var photo= document.getElementById('photo').files[0];
        var name_english = $('#name_english').val();
        var name_arabic = $('#name_arabic').val();
        var description_english = $('#description_english').val();
        var description_arabic = $('#description_arabic').val();
        var price = $('#price').val();
        var quantity_avail = $('#quantity_avail').val();
        var law_category = $('#category_list').val();




        var formData = new FormData();
        formData.append("name_english", name_english);
        formData.append("name_arabic", name_arabic);
        formData.append("description_english", description_english);
        formData.append("description_arabic", description_arabic);
        formData.append("price", price);
        formData.append("quantity_avail", quantity_avail);
        formData.append("law_category", law_category);
        formData.append("photo", photo);


        $.ajax
        ({
          type:'POST',
          url:"https://maktabty.org/Maktabti/api/AddItem",
          data: formData,
          contentType: false,
          cache: false,
          processData:false,
          success: function(data)
          {
            if( data.status == "success")
            {
               bk_id = data.book_id;
             // alert (bk_id);
              $('#regForm').css('display','none');
              $('#regForm2').css('display','block');
            }
            else if( data.status == "failed" )
            {
              //l.ladda('stop');
              errorMessage = data.error;
              //swal_btn2.click();
            }
          },
          error: function(data) 
          {
            alert("error");
          }           

        });                
              return false; // extra insurance preventing the default form action
            }
          });

     $("#regForm2").validate({
      rules: 
      {
        photo: {
          required: true
        },
        name_english: {
          required: true,
        },
        name_arabic: {
          required: true,
        }
      },
      messages: 
      {
      },
      submitHandler: function(form) 
      {
        //var l = $( '.ladda-button-demo' ).ladda();
        //l.ladda( 'start' );
        var swal_btn = document.getElementById("swal_btn");

        var photo= document.getElementById('photo').files[0];
        var name_english = $('#name_english').val();
        var name_arabic = $('#name_arabic').val();
        var description_english = $('#description_english').val();
        var description_arabic = $('#description_arabic').val();
        var price = $('#price').val();
        var quantity_avail = $('#quantity_avail').val();
        var law_category = $('#law_category').val();




        var formData = new FormData();
        formData.append("book_id", bk_id);
        formData.append("photo", photo);


        $.ajax
        ({
          type:'POST',
          url:"https://maktabty.org/Maktabti/api/BooksImages",
          data: formData,
          contentType: false,
          cache: false,
          processData:false,
          success: function(data)
          {
            if( data.status == "success")
            {
              //l.ladda('stop');
              //swal_btn.click();
             alert ("success");
            }
            else if( data.status == "failed" )
            {
              //l.ladda('stop');
              errorMessage = data.error;
              //swal_btn2.click();
            }
          },
          error: function(data) 
          {
            alert("error");
          }           

        });                
              return false; // extra insurance preventing the default form action
            }
          });


    $('#swal_btn').click(function(){
      swal({
        title: "Book added successfully!",
        text: "",
        type: "success",
        confirmButtonColor: "#566b8a",
        closeOnConfirm: false
      }, function () {
        window.location.assign("{{ url('view_books')}}");
      });
    });

    $('#swal_btn2').click(function(){
      swal({
       title: "Operation Unsuccessfull!",
       text: errorMessage,
       type: "warning",
       confirmButtonColor: "#DD6B55",
     });
    });
  });

 function viewCategories()
    {
        var $list = $("#category_list");
        $list.empty();
        $.ajax({
            url: "https://maktabty.org/Maktabti/api/CategoryView",
            type: "POST",
            success: function(data)
            {   
                if ( data.status == "success")
                {
                    $list.append('<option value="select">Choose a Category</option>');
                    $.each(data.data, function(index,obj) 
                    {
                        $list.append('<option value="'+obj.category_name+'">'+obj.category_name+'</option>');
                    });
                }
                else
                {
                    swal_btn.click();
                }
            },
            error: function(data)
            {
            }           
        });        
    }

</script>

<script>
function fixStepIndicator(n) {
// This function removes the "active" class of all steps...
var i, x = document.getElementsByClassName("step");
for (i = 0; i < x.length; i++) {
  x[i].className = x[i].className.replace(" active", "");
}
//... and adds the "active" class on the current step:
x[n].className += " active";
}
</script>

<script>
  function readURL(input) {
    if (input.files && input.files[0]) {
      var reader = new FileReader();

      reader.onload = function (e) {
        $('#blah')
        .attr('src', e.target.result)
        .width(150)
        .height(200);
      };

      reader.readAsDataURL(input.files[0]);
    }
  }
</script>
</body>
</html>
