<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:api');

Route::post('test','Controller@test');
Route::post('TestNotif','Controller@TestNotif');

Route::post('mail/SendHoursMail', 'Controller@SendHoursMail');

Route::post('Home','CategoryController@Home');

//garage App
Route::post('AddGrProjects','Controller@AddGrProjects');
Route::post('AddProjectEnteries','Controller@AddProjectEnteries');
Route::get('ViewGrProjects','Controller@ViewGrProjects');

Route::post('AddGarCustomer','Controller@AddGarCustomer');
Route::post('AddGarCustomerVehicle','Controller@AddGarCustomerVehicle');
Route::post('AddGarageServices','Controller@AddGarageServices');
Route::post('GarServiceStatUpdate','Controller@GarServiceStatUpdate');
Route::get('GarSearchCusVehicle','Controller@GarSearchCusVehicle');
Route::get('GarCustVehicleHistory','Controller@GarCustVehicleHistory');

//Employee Routes
Route::post('AdminSignIn','Controller@AdminSignIn');
Route::post('EmployeeSignin','Controller@EmployeeSignin');
Route::post('EmployeeSigninEmployee','Controller@EmployeeSigninEmployee');
Route::post('EmployeeSigninAdminWeb','Controller@EmployeeSigninAdminWeb');

Route::post('EmployeeSignup','Controller@EmployeeSignup');
Route::post('EditEmployee','Controller@EditEmployee');
Route::post('EditEmployeeEmail','Controller@EditEmployeeEmail');
Route::get('ViewAllEmployees','Controller@ViewAllEmployees');
Route::get('ViewEmployee','Controller@ViewEmployee');
Route::get('DeleteEmployee','Controller@DeleteEmployee');

//Position Routes
Route::post('AddPosition','Controller@AddPosition');
Route::get('ActivePosition','Controller@ActivePosition');
Route::get('ViewAllPositions','Controller@ViewAllPositions');
Route::get('DeletePosition','Controller@DeletePosition');

//Time Clock Routes

Route::post('DumpClockinTime','Controller@DumpClockinTime');
Route::post('DumpBreakTime','Controller@DumpBreakTime');
Route::post('DumpBacktoworkTime','Controller@DumpBacktoworkTime');
Route::post('DumpClockoutTime','Controller@DumpClockoutTime');



Route::post('AddClockinTime','Controller@AddClockinTime');
Route::post('AddClockinTimeDup','Controller@AddClockinTimeDup');
Route::post('BreaksClockinTime','Controller@BreaksClockinTime');
Route::post('BreaksClockinTimeTest','Controller@BreaksClockinTimeTest');
Route::post('EditEmployeeTime','Controller@EditEmployeeTime');
Route::post('ConfirmEmployeeTime','Controller@ConfirmEmployeeTime');
Route::post('EmployeeSigninEmail','Controller@EmployeeSigninEmail');
Route::post('AddNoteTimeclock','Controller@AddNoteTimeclock');

Route::post('AddClockoutTime','Controller@AddClockoutTime');
Route::post('AddClockoutTimeTest','Controller@AddClockoutTimeTest');
Route::get('DeleteClockIn','Controller@DeleteClockIn');

Route::post('AddTimeclockNotifs','Controller@AddTimeclockNotifs');
Route::get('ViewTimeclockNotifs','Controller@ViewTimeclockNotifs');
Route::post('BackToWork','Controller@BackToWork');
Route::get('ViewAllPositions','Controller@ViewAllPositions');
Route::get('ViewClockedInEmployees','Controller@ViewClockedInEmployees');
Route::get('ViewOnClockEmployees','Controller@ViewOnClockEmployees');
Route::get('ViewOnClockWebEmployees','Controller@ViewOnClockWebEmployees');
Route::get('AdvanceLoanTotal','Controller@AdvanceLoanTotal');
Route::get('ViewOnClockEmployees2','Controller@ViewOnClockEmployees2');
Route::get('DeletePosition','Controller@DeletePosition');

Route::post('AddPaymentAdvance','Controller@AddPaymentAdvance');
Route::get('ViewAdvancePaymentsEmp','Controller@ViewAdvancePaymentsEmp');

//Tax Routes
Route::post('AddTax','Controller@AddTax');
Route::post('EditTax','Controller@EditTax');
Route::get('ViewTax','Controller@ViewTax');
Route::get('ViewSingleTax','Controller@ViewSingleTax');
Route::get('DeleteTax','Controller@DeleteTax');

//Rate per Hour Routes
Route::post('AddRateHour','Controller@AddRateHour');
Route::post('EditRateHour','Controller@EditRateHour');
Route::get('ViewAllRateHours','Controller@ViewAllRateHours');
Route::get('ViewRatePerHour','Controller@ViewRatePerHour');
Route::get('DeleteRateHour','Controller@DeleteRateHour');

//Agreemend Routes
Route::post('AddAgreement','Controller@AddAgreement');
Route::post('EditAgreement','Controller@EditAgreement');
Route::get('ViewAgreement','Controller@ViewAgreement');
Route::get('ViewSingleAgreement','Controller@ViewSingleAgreement');
Route::get('DeleteAgreement','Controller@DeleteAgreement');

//Location Routes
Route::post('AddLocations','Controller@AddLocations');
Route::post('EditLocations','Controller@EditLocations');
Route::get('GetLocation','Controller@GetLocation');
Route::get('DeleteLocation','Controller@DeleteLocation');

//CUSTOMER Routes
Route::post('CustomerSignup','Controller@CustomerSignup');
Route::post('EditCustomerProfile','Controller@EditCustomerProfile');
Route::post('UpdateCustomerStatus','Controller@UpdateCustomerStatus');
Route::post('CustomerPhoneEdit','Controller@CustomerPhoneEdit');
Route::post('CustomerPwdChange','Controller@CustomerPwdChange');
Route::post('CustomerSignin','Controller@CustomerSignin');
Route::get('CustomerSearch','Controller@CustomerSearch');


Route::get('VerifyEmail','Controller@VerifyEmail');

//Balance Routes
Route::post('AddBalance','Controller@AddBalance');
Route::post('CloseBalance','Controller@CloseBalance');
Route::post('GetClosingBalance','Controller@GetClosingBalance');

Route::get('DeleteChild','Controller@DeleteChild');

//Bookings ROutes
Route::post('AddBooking','Controller@AddBooking');
Route::post('MultipleBookings','Controller@MultipleBookings');
Route::post('UpdateBooking','Controller@UpdateBooking');
Route::post('AddAddedHours','Controller@AddAddedHours');

//Backup Email

Route::post('AddBackupEmail','Controller@AddBackupEmail');
Route::get('ViewBackupEmail','Controller@ViewBackupEmail');
Route::get('ViewSingleBackupEmail','Controller@ViewSingleBackupEmail');
Route::get('DeleteBackupEmail','Controller@DeleteBackupEmail');
Route::get('ActiveBackupEmail','Controller@ActiveBackupEmail');

//Qr Routes
Route::post('AddQrCode','Controller@AddQrCode');
Route::post('EditQrStatus','Controller@EditQrStatus');
Route::post('GetQrStatus','Controller@GetQrStatus');

Route::post('AddBatch','Controller@AddBatch');
Route::get('GetBatchNumber','Controller@GetBatchNumber');
Route::post('Addregisters','Controller@Addregisters');
Route::get('ViewRegisters','Controller@ViewRegisters');
Route::get('ViewPhoneRequirement','Controller@ViewPhoneRequirement');
Route::post('UpdateStatusRegister','Controller@UpdateStatusRegister');