<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Dry Clean Locker | Orders </title>

    <link href="<?php echo e(asset ('css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset ('font-awesome/css/font-awesome.css')); ?>" rel="stylesheet">

    <!-- FooTable -->
    <link href="<?php echo e(asset ('css/plugins/footable/footable.core.css')); ?>" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="<?php echo e(asset ('css/sweetalert.css')); ?>" rel="stylesheet">

    <link href="<?php echo e(asset ('css/animate.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset ('css/style.css')); ?>" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
        .container 
        {
          margin-top: 15px;
        }
        .tab-group
        {
           position: relative;
           vertical-align: middle;
           zoom: 1; /* Fix for IE7 */
           *display: inline; /* Fix for IE7 */
        }
        
        .tab-group > li
        {
            background-color: #eeeeee;
            border-radius: 4px;
            position: relative;
            float: left;
        }
        .nav > li.active 
        {
            border-left: 4px solid #566b8a;
            background: #566b8a;
        }
        .tab-group > li.active > a, 
        .tab-group > li.active > a:hover, 
        .tab-group > li.active > a:focus
        {
            background-color: #566b8a;
            color: #fff;
        }
        .tab-group > li > a 
        {
            color: #333;
            border-radius: 0;
            text-align: center;
        }
        .tab-group > li > a:hover 
        {
            border-radius: 4px;
        }
        
        .tab-group li + li 
        {
            margin-left: -1px;
        }
        
        .tab-group > li:not(:first-child):not(:last-child),
        .tab-group > li:not(:first-child):not(:last-child) > a:hover 
        {
          border-radius: 0;
        }
        .tab-group > li:first-child,
        .tab-group > li:first-child > a:hover 
        {
            margin-left: 0;
        }
        .tab-group > li:first-child:not(:last-child),
        .tab-group > li:first-child:not(:last-child) > a:hover 
        {
          border-top-right-radius: 0;
          border-bottom-right-radius: 0;
        }
        .tab-group > li:last-child:not(:first-child),
        .tab-group > li:last-child:not(:first-child) > a:hover 
        {
          border-top-left-radius: 0;
          border-bottom-left-radius: 0;
        }
    </style>
</head>
<body>
    <div id="wrapper">

        <!-- Side Navbar -->
        <?php echo $__env->make('navbar_static_side', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?> 

        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <!-- Top Navbar -->
                <?php echo $__env->make('navbar_static_top', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?> 
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><strong>Orders</strong></h2>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">

                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Order Id</th>
                                            <th>Person Name</th>
                                            <th>Address</th>
                                            <th>Shipping Address</th>
                                            <th>Phone</th>
                                            <th>Person Email</th>
                                            <th>Payment Method</th>
											<th>Order Total</th>
                                            <th>Order Type</th>
                                            <th>Customer Type</th>
                                          
                                            <th>View Items</th>
                                        </tr>
                                    </thead>
                                    <tbody id="orders_list">
                                       <!-- Dynamically appending Employees List -->                                     
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="6">
                                                <ul class="pagination pull-right"></ul>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none"></button>
            <!-- Delete Row -->
            <button id="swal_btn2" type="button" style="display:none"></button>

            <!-- Footer -->
            <?php echo $__env->make('footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

        </div>
    </div>

    <!-- Mainly scripts -->
    <script src="<?php echo e(asset ('js/jquery-3.1.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset ('js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset ('js/plugins/metisMenu/jquery.metisMenu.js')); ?>"></script>
    <script src="<?php echo e(asset ('js/plugins/slimscroll/jquery.slimscroll.min.js')); ?>"></script>

    <!-- Custom and plugin javascript -->
    <script src="<?php echo e(asset ('js/inspinia.js')); ?>"></script>
    <script src="<?php echo e(asset ('js/plugins/pace/pace.min.js')); ?>"></script>

    <!-- Sweet alert -->
    <script src="<?php echo e(asset ('js/plugins/sweetalert/sweetalert.min.js')); ?>"></script>

    <!-- FooTable -->
    <script src="<?php echo e(asset ('js/plugins/footable/footable.all.min.js')); ?>"></script>

    <!-- Page-Level Scripts -->
    <script>
        var order_data;
        var pickUpLockerColor;
        var returnLockerColor;
        var orderCurrentDateTime;

        $(document).ready(function() 
        {
            $("#side2").addClass("activeSM");
            $("#side2 a").css("color","#224ea6");

            $('.search-panel .dropdown-menu').find('a').click(function(e) {
                e.preventDefault();
                var param = $(this).attr("href").replace("#","");
                var concept = $(this).text();
                $('.search-panel span#search_concept').text(concept);
                $('.input-group #search_param').val(param);
            });

            $(".TAB").click(function()
            {
                $('.tab-group li').css('color' , '#333');
                $('.tab-group li').css('background-color' , '#eeeeee');
                $('.tab-group li a').css('background-color' , '#eeeeee');
                $('.tab-group li').css('border-left' , '4px solid #eeeeee');

                var status = this.id;
                var bcolor;
                var color;

               

                $('#'+this.id).css('background-color' , bcolor);
                $('#'+this.id).css('border-left' , '4px solid '+bcolor);
                $('#'+this.id+' a').css('background-color' , bcolor);
                $('#'+this.id).css('color' , color);
                viewOrders(this.id,bcolor);
            });

            viewOrders("All","#566b8a");

            //Empty List
            $('#swal_btn').click(function(){
                swal({
                     title: "List is Empty!",
                    text: "No Record Found",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                    closeOnConfirm: false
            }, function () {
                window.location.assign("<?php echo e(url('view_item')); ?>");
                });
            });
        });

        function viewOrders(status,color)
        {
            var $list = $("#orders_list");
            $list.empty();
            $.ajax({
                url: "http://tecjaunt.com/Maktabti/api/ViewAllOrder",
                type: "POST",
                //data: { "OrderStatus" : status},
                success: function(data)
                {   
                    var count = 1;
                    var returnLockerID;

                    //Saving Complete object.
                    if(status == "All")
                    {
                        order_data = data;
                    }

                    if ( data.status == "success")
                    {
                        $.each(data.data, function(index,obj) 
                        {
                            

                        //alert (data);

                            $list.append('<tr>'+
                                            '<td><strong>'+count+'</strong></td>'+
                                            '<td>'+obj.order_id+'</td>'+
                                            '<td>'+obj.name+'</td>'+
											'<td>'+obj.address+'</td>'+
											'<td>'+obj.shipping_add+'</td>'+
											'<td>'+obj.phone+'</td>'+
											'<td>'+obj.email+'</td>'+
											
											'<td>'+obj.payment_method+'</td>'+
											'<td>'+obj.order_total+'</td>'+
											'<td>'+obj.order_type+'</td>'+
											'<td>'+obj.customer_type+'</td>'+
											
											
                                            
                                            '<td>'+
                                                '<div class="btn-group">'+
                                                    /*'<button id="'+obj.OrderID+'" onclick ="saveOrder(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/edit_icon.png" /></button>'+*/
                                                    '<button id="'+obj.order_id+'" onclick ="viewSingleOrder(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/view_icon.png" /></button>'+
                                                '</div>'+
                                            '</td>'+
                                        '</tr>');
                            count++;
                        });
                    }
                    else
                    {
                        swal_btn.click();
                    }
                },
                error: function(data)
                {
                }           
            });        
        }

        function viewSingleOrder(id)
        {
            var order_details_id = id;
            localStorage.setItem("order_details_id",order_details_id);
            window.location.href = "<?php echo e(url('order_details')); ?>";
        }

        /*
        function saveOrder(id)
        {
            var order_id = id;
            localStorage.setItem("order_id",order_id);
            window.location.href = "<?php echo e(url('edit_order')); ?>";
        }*/

        function searchFilter()
        {
            var search_option = $('#search_concept').html();

            if(search_option == "All")
            {
                $('#search_box').val("All");
            }
            var search_value = $('#search_box').val();

            if( search_option != "Filter by" && search_value )
            {
                var $list = $("#orders_list");
                $list.empty();

                var count = 1;
                var color;

                if( search_option == "Person Email" )
                {
                    $.each(order_data.data, function(index,obj) 
                    {
                        if(obj.OrderStatus == "Pending")
                        {
                            color = "red";
                            orderCurrentDateTime = obj.order_time;
                        }
                        else if(obj.OrderStatus == "Collected")
                        {
                            color = "blue";
                            orderCurrentDateTime = obj.TimeCollected;
                        }
                        else if(obj.OrderStatus == "Delivered")
                        {
                            color = "green";
                            orderCurrentDateTime = obj.TimeDelivered;
                        }
                        else if(obj.OrderStatus == "Completed")
                        {
                            color = "orange";
                            orderCurrentDateTime = obj.TimeCompleted;
                        }

                        if( search_value == obj.PersonID )
                        {
                            if(obj.ReturnLockerID)
                            {
                                returnLockerID = obj.ReturnLockerID;
                                pickUpLockerColor = "red";
                                returnLockerColor = "green";

                            }
                            else
                            {
                                returnLockerID = "___";
                                pickUpLockerColor = "green";
                                returnLockerColor = "red";
                            }

                            $list.append('<tr>'+
                                            '<td><strong>'+count+'</strong></td>'+
                                            '<td>'+obj.OrderID+'</td>'+
                                            '<td>'+obj.PersonID+'</td>'+
                                            '<td>'+orderCurrentDateTime+'</td>'+
                                            '<td style="color:'+pickUpLockerColor+'"><strong>'+obj.PickupLockerID+'</strong></td>'+
                                            '<td style="color:'+returnLockerColor+'"><strong>'+returnLockerID+'</strong></td>'+
                                            '<td>'+obj.LockOpenCode+'</td>'+
                                            '<td>'+obj.DocketNum+'</td>'+
                                            '<td style="color: '+color+'">'+obj.OrderStatus+'</td>'+
                                            '<td>'+
                                                '<div class="btn-group">'+
                                                    '<button id="'+obj.OrderID+'" onclick ="saveOrder(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/edit_icon.png" /></button>'+
                                                    '<button id="'+obj.OrderID+'" onclick ="viewSingleOrder(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/view_icon.png" /></button>'+
                                                '</div>'+
                                            '</td>'+
                                        '</tr>');
                            count++;
                        }
                    });
                    if( count == 1)
                    {
                        $list.append('<tr><td colspan="5"><h2>No record found.</h2></td></tr>');
                        $('#search_box').val("");
                    }
                }
                else if( search_option == "Docket Number" )
                {
                    $.each(order_data.data, function(index,obj) 
                    {
                        if(obj.OrderStatus == "Pending")
                        {
                            color = "red";
                            orderCurrentDateTime = obj.order_time;
                        }
                        else if(obj.OrderStatus == "Collected")
                        {
                            color = "blue";
                            orderCurrentDateTime = obj.TimeCollected;
                        }
                        else if(obj.OrderStatus == "Delivered")
                        {
                            color = "green";
                            orderCurrentDateTime = obj.TimeDelivered;
                        }
                        else if(obj.OrderStatus == "Completed")
                        {
                            color = "orange";
                            orderCurrentDateTime = obj.TimeCompleted;
                        }

                        if( search_value == obj.DocketNum )
                        {
                            if(obj.ReturnLockerID)
                            {
                                returnLockerID = obj.ReturnLockerID;
                                pickUpLockerColor = "red";
                                returnLockerColor = "green";
                            }
                            else
                            {
                                returnLockerID = "___";
                                pickUpLockerColor = "green";
                                returnLockerColor = "red";
                            }

                            $list.append('<tr>'+
                                            '<td><strong>'+count+'</strong></td>'+
                                            '<td>'+obj.OrderID+'</td>'+
                                            '<td>'+obj.PersonID+'</td>'+
                                            '<td>'+orderCurrentDateTime+'</td>'+
                                            '<td style="color:'+pickUpLockerColor+'"><strong>'+obj.PickupLockerID+'</strong></td>'+
                                            '<td style="color:'+returnLockerColor+'"><strong>'+returnLockerID+'</strong></td>'+
                                            '<td>'+obj.LockOpenCode+'</td>'+
                                            '<td>'+obj.DocketNum+'</td>'+
                                            '<td style="color: '+color+'">'+obj.OrderStatus+'</td>'+
                                            '<td>'+
                                                '<div class="btn-group">'+
                                                    '<button id="'+obj.OrderID+'" onclick ="saveOrder(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/edit_icon.png" /></button>'+
                                                    '<button id="'+obj.OrderID+'" onclick ="viewSingleOrder(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/view_icon.png" /></button>'+
                                                '</div>'+
                                            '</td>'+
                                        '</tr>');
                            count++;
                        }
                    });
                    if( count == 1)
                    {
                        $list.append('<tr><td colspan="5"><h2>No record found.</h2></td></tr>');
                        $('#search_box').val("");
                    }
                }
                else if( search_option == "Date and Time" )
                {
                    $.each(order_data.data, function(index,obj) 
                    {
                        if(obj.OrderStatus == "Pending")
                        {
                            color = "red";
                            orderCurrentDateTime = obj.order_time;
                        }
                        else if(obj.OrderStatus == "Collected")
                        {
                            color = "blue";
                            orderCurrentDateTime = obj.TimeCollected;
                        }
                        else if(obj.OrderStatus == "Delivered")
                        {
                            color = "green";
                            orderCurrentDateTime = obj.TimeDelivered;
                        }
                        else if(obj.OrderStatus == "Completed")
                        {
                            color = "orange";
                            orderCurrentDateTime = obj.TimeCompleted;
                        }

                        if( search_value == orderCurrentDateTime )
                        {
                            if(obj.ReturnLockerID)
                            {
                                returnLockerID = obj.ReturnLockerID;
                                pickUpLockerColor = "red";
                                returnLockerColor = "green";
                            }
                            else
                            {
                                returnLockerID = "___";
                                pickUpLockerColor = "green";
                                returnLockerColor = "red";
                            }

                            $list.append('<tr>'+
                                            '<td><strong>'+count+'</strong></td>'+
                                            '<td>'+obj.OrderID+'</td>'+
                                            '<td>'+obj.PersonID+'</td>'+
                                            '<td>'+orderCurrentDateTime+'</td>'+
                                            '<td style="color:'+pickUpLockerColor+'"><strong>'+obj.PickupLockerID+'</strong></td>'+
                                            '<td style="color:'+returnLockerColor+'"><strong>'+returnLockerID+'</strong></td>'+
                                            '<td>'+obj.LockOpenCode+'</td>'+
                                            '<td>'+obj.DocketNum+'</td>'+
                                            '<td style="color: '+color+'">'+obj.OrderStatus+'</td>'+
                                            '<td>'+
                                                '<div class="btn-group">'+
                                                    '<button id="'+obj.OrderID+'" onclick ="saveOrder(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/edit_icon.png" /></button>'+
                                                    '<button id="'+obj.OrderID+'" onclick ="viewSingleOrder(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/view_icon.png" /></button>'+
                                                '</div>'+
                                            '</td>'+
                                        '</tr>');
                            count++;
                        }
                    });
                    if( count == 1)
                    {
                        $list.append('<tr><td colspan="5"><h2>No record found.</h2></td></tr>');
                        $('#search_box').val("");
                    }
                }
                else if( search_option == "Locker Number" )
                {
                    $.each(order_data.data, function(index,obj) 
                    {
                        if(obj.OrderStatus == "Pending")
                        {
                            color = "red";
                            orderCurrentDateTime = obj.order_time;
                        }
                        else if(obj.OrderStatus == "Collected")
                        {
                            color = "blue";
                            orderCurrentDateTime = obj.TimeCollected;
                        }
                        else if(obj.OrderStatus == "Delivered")
                        {
                            color = "green";
                            orderCurrentDateTime = obj.TimeDelivered;
                        }
                        else if(obj.OrderStatus == "Completed")
                        {
                            color = "orange";
                            orderCurrentDateTime = obj.TimeCompleted;
                        }

                        if( search_value == obj.PickupLockerID || search_value == obj.ReturnLockerID )
                        {
                            if(obj.ReturnLockerID)
                            {
                                returnLockerID = obj.ReturnLockerID;
                                pickUpLockerColor = "red";
                                returnLockerColor = "green";
                            }
                            else
                            {
                                returnLockerID = "___";
                                pickUpLockerColor = "green";
                                returnLockerColor = "red";
                            }

                            $list.append('<tr>'+
                                            '<td><strong>'+count+'</strong></td>'+
                                            '<td>'+obj.OrderID+'</td>'+
                                            '<td>'+obj.PersonID+'</td>'+
                                            '<td>'+orderCurrentDateTime+'</td>'+
                                            '<td style="color:'+pickUpLockerColor+'"><strong>'+obj.PickupLockerID+'</strong></td>'+
                                            '<td style="color:'+returnLockerColor+'"><strong>'+returnLockerID+'</strong></td>'+
                                            '<td>'+obj.LockOpenCode+'</td>'+
                                            '<td>'+obj.DocketNum+'</td>'+
                                            '<td style="color: '+color+'">'+obj.OrderStatus+'</td>'+
                                            '<td>'+
                                                '<div class="btn-group">'+
                                                    '<button id="'+obj.OrderID+'" onclick ="saveOrder(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/edit_icon.png" /></button>'+
                                                    '<button id="'+obj.OrderID+'" onclick ="viewSingleOrder(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/view_icon.png" /></button>'+
                                                '</div>'+
                                            '</td>'+
                                        '</tr>');
                            count++;
                        }
                    });
                    if( count == 1)
                    {
                        $list.append('<tr><td colspan="5"><h2>No record found.</h2></td></tr>');
                        $('#search_box').val("");
                    }
                }
                else
                {
                   $.each(order_data.data, function(index,obj) 
                    {
                       if(obj.OrderStatus == "Pending")
                        {
                            color = "red";
                            orderCurrentDateTime = obj.order_time;
                        }
                        else if(obj.OrderStatus == "Collected")
                        {
                            color = "blue";
                            orderCurrentDateTime = obj.TimeCollected;
                        }
                        else if(obj.OrderStatus == "Delivered")
                        {
                            color = "green";
                            orderCurrentDateTime = obj.TimeDelivered;
                        }
                        else if(obj.OrderStatus == "Completed")
                        {
                            color = "orange";
                            orderCurrentDateTime = obj.TimeCompleted;
                        }

                        if(obj.ReturnLockerID)
                        {
                            returnLockerID = obj.ReturnLockerID;
                            pickUpLockerColor = "red";
                            returnLockerColor = "green";
                        }
                        else
                        {
                            returnLockerID = "___";
                            pickUpLockerColor = "green";
                            returnLockerColor = "red";
                        }

                        $list.append('<tr>'+
                                        '<td><strong>'+count+'</strong></td>'+
                                        '<td>'+obj.OrderID+'</td>'+
                                        '<td>'+obj.PersonID+'</td>'+
                                        '<td>'+orderCurrentDateTime+'</td>'+
                                        '<td style="color:'+pickUpLockerColor+'"><strong>'+obj.PickupLockerID+'</strong></td>'+
                                        '<td style="color:'+returnLockerColor+'"><strong>'+returnLockerID+'</strong></td>'+
                                        '<td>'+obj.LockOpenCode+'</td>'+
                                        '<td>'+obj.DocketNum+'</td>'+
                                        '<td style="color: '+color+'">'+obj.OrderStatus+'</td>'+
                                        '<td>'+
                                            '<div class="btn-group">'+
                                                '<button id="'+obj.OrderID+'" onclick ="saveOrder(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/edit_icon.png" /></button>'+
                                                '<button id="'+obj.OrderID+'" onclick ="viewSingleOrder(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/view_icon.png" /></button>'+
                                            '</div>'+
                                        '</td>'+
                                    '</tr>');
                        count++;
                    });
                }
            }
            else
            {
                alert("Please select filter and enter search parameter");
            }
        }
        
    </script>
</body>
</html>
