<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Dry Clean Locker | Country </title>

    <link href="<?php echo e(asset ('css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset ('font-awesome/css/font-awesome.css')); ?>" rel="stylesheet">

    <!-- FooTable -->
    <link href="<?php echo e(asset ('css/plugins/footable/footable.core.css')); ?>" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="<?php echo e(asset ('css/sweetalert.css')); ?>" rel="stylesheet">

    <link href="<?php echo e(asset ('css/animate.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset ('css/style.css')); ?>" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
</head>
<body>
    <div id="wrapper">

        <!-- Side Navbar -->
        <?php echo $__env->make('navbar_static_side', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?> 

        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <!-- Top Navbar -->
                <?php echo $__env->make('navbar_static_top', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?> 
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><strong>Countries</strong></h2>
                    <a href="<?php echo e(url('add_country')); ?>">
                        <button type="button" class="btn btn-default btn-sm">
                            <span class="glyphicon glyphicon-plus"></span> Add a Country
                        </button>
                    </a>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Country Name</th>                                            
                                            <th>Phone Code</th>
                                            <th>Currency Code</th>
                                            <th>Currency Symbol</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody id="country_list">
                                       <!-- Dynamically appending Employees List -->
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="6">
                                                <ul class="pagination pull-right"></ul>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none">
            <!-- Delete Row -->
            <button id="swal_btn2" type="button" style="display:none">
            <!-- Active/Inactive row -->
            <button id="swal_btn3" type="button" style="display:none">

            <!-- Footer -->
            <?php echo $__env->make('footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="deleteModal" role="dialog">
        <div class="modal-dialog">
          <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Delete Country</h4>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to delete a Country?</p>
                </div>
                <div class="modal-footer">
                     <button type="button" class="btn btn-default" style="background-color: #1ab394; color: white" onclick="deleteCountry()">Yes</button>
                    <button type="button" class="btn btn-default" style="background-color: #ed5565; color: white" data-dismiss="modal">No</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal Close -->

    <!-- Hidden field to get the Symbol-->
    <div class="form-group" style="display: none;">
        <label>Currency Symbol</label>
        <select class="form-control" id="currency_symbol" name="currency_symbol" required="">
            <option id="AED">&#1583;&#1573;</option>
            <option id="AFN">&#65;&#102;</option>
            <option id="ALL">&#76;&#101;&#107;</option>
            <option id="AMD"></option>
            <option id="ANG">&#402;</option>
            <option id="AOA">&#75;&#122;</option>
            <option id="ARS">&#36;</option>
            <option id="AUD">&#36;</option>
            <option id="AWG">&#402;</option>
            <option id="AZN">&#1084;&#1072;&#1085;</option>
            <option id="BAM">&#75;&#77;</option>
            <option id="BBD">&#36;</option>
            <option id="BDT">&#2547;</option>
            <option id="BGN">&#1083;&#1074;</option>
            <option id="BHD">&#1583;.&#1576;</option>
            <option id="BIF">&#70;&#66;&#117;</option>
            <option id="BMD">&#36;</option>
            <option id="BND">&#36;</option>
            <option id="BOB">&#36;&#98;</option>
            <option id="BRL">&#82;&#36;</option>
            <option id="BSD">&#36;</option>
            <option id="BTN">&#78;&#117;&#46;</option>
            <option id="BWP">&#80;</option>
            <option id="BYR">&#112;&#46;</option>
            <option id="BZD">&#66;&#90;&#36;</option>
            <option id="CAD">&#36;</option>
            <option id="CDF">&#70;&#67;</option>
            <option id="CHF">&#67;&#72;&#70;</option>
            <option id="CLF"></option>
            <option id="CLP">&#36;</option>
            <option id="CNY">&#165;</option>
            <option id="COP">&#36;</option>
            <option id="CRC">&#8353;</option>
            <option id="CUP">&#8396;</option>
            <option id="CVE">&#36;</option>
            <option id="CZK">&#75;&#269;</option>
            <option id="DJF">&#70;&#100;&#106;</option>
            <option id="DKK">&#107;&#114;</option>
            <option id="DOP">&#82;&#68;&#36;</option>
            <option id="DZD">&#1583;&#1580;</option>
            <option id="EGP">&#163;</option>
            <option id="ETB">&#66;&#114;</option>
            <option id="EUR">&#8364;</option>
            <option id="FJD">&#36;</option>
            <option id="FKP">&#163;</option>
            <option id="GBP" selected="">&#163;</option>
            <option id="GEL">&#4314;</option>
            <option id="GHS">&#162;</option>
            <option id="GIP">&#163;</option>
            <option id="GMD">&#68;</option>
            <option id="GNF">&#70;&#71;</option>
            <option id="GTQ">&#81;</option>
            <option id="GYD">&#36;</option>
            <option id="HKD">&#36;</option>
            <option id="HNL">&#76;</option>
            <option id="HRK">&#107;&#110;</option>
            <option id="HTG">&#71;</option>
            <option id="HUF">&#70;&#116;</option>
            <option id="IDR">&#82;&#112;</option>
            <option id="ILS">&#8362;</option>
            <option id="INR">&#8377;</option>
            <option id="IQD">&#1593;&#1583;</option>
            <option id="IRR">&#65020;</option>
            <option id="ISK">&#107;&#114;</option>
            <option id="JEP">&#163;</option>
            <option id="JMD">&#74;&#36;</option>
            <option id="JOD">&#74;&#68;</option>
            <option id="JPY">&#165;</option>
            <option id="KES">&#75;&#83;&#104;</option>
            <option id="KGS">&#1083;&#1074;</option>
            <option id="KHR">&#6107;</option>
            <option id="KMF">&#67;&#70;</option>
            <option id="KPW">&#8361;</option>
            <option id="KRW">&#8361;</option>
            <option id="KWD">&#1583;.&#1603;</option>
            <option id="KYD">&#36;</option>
            <option id="KZT">&#1083;&#1074;</option>
            <option id="LAK">&#8365;</option>
            <option id="LBP">&#163;</option>
            <option id="LKR">&#8360;</option>
            <option id="LRD">&#36;</option>
            <option id="LSL">&#76;</option>
            <option id="LTL">&#76;&#116;</option>
            <option id="LVL">&#76;&#115;</option>
            <option id="LYD">&#1604;.&#1583;</option>
            <option id="MAD">&#1583;.&#1605;</option>
            <option id="MDL">&#76;</option>
            <option id="MGA">&#65;&#114;</option>
            <option id="MKD">&#1076;&#1077;&#1085;</option>
            <option id="MMK">&#75;</option>
            <option id="MNT">&#8366;</option>
            <option id="MOP">&#77;&#79;&#80;&#36;</option>
            <option id="MRO">&#85;&#77;</option>
            <option id="MUR">&#8360;</option>
            <option id="MVR">&#1923;</option>
            <option id="MWK">&#77;&#75;</option>
            <option id="MXN">&#36;</option>
            <option id="MYR">&#82;&#77;</option>
            <option id="MZN">&#77;&#84;</option>
            <option id="NAD">&#36;</option>
            <option id="NGN">&#8358;</option>
            <option id="NIO">&#67;&#36;</option>
            <option id="NOK">&#107;&#114;</option>
            <option id="NPR">&#8360;</option>
            <option id="NZD">&#36;</option>
            <option id="OMR">&#65020;</option>
            <option id="PAB">&#66;&#47;&#46;</option>
            <option id="PEN">&#83;&#47;&#46;</option>
            <option id="PGK">&#75;</option>
            <option id="PHP">&#8369;</option>
            <option id="PKR">&#8360;</option>
            <option id="PLN">&#122;&#322;</option>
            <option id="PYG">&#71;&#115;</option>
            <option id="QAR">&#65020;</option>
            <option id="RON">&#108;&#101;&#105;</option>
            <option id="RSD">&#1044;&#1080;&#1085;&#46;</option>
            <option id="RUB">&#1088;&#1091;&#1073;</option>
            <option id="RWF">&#1585;&#1587;</option>
            <option id="SAR">&#65020;</option>
            <option id="SBD">&#36;</option>
            <option id="SCR">&#8360;</option>
            <option id="SDG">&#163;</option>
            <option id="SEK">&#107;&#114;</option>
            <option id="SGD">&#36;</option>
            <option id="SHP">&#163;</option>
            <option id="SLL">&#76;&#101;</option>
            <option id="SOS">&#83;</option>
            <option id="SRD">&#36;</option>
            <option id="STD">&#68;&#98;</option>
            <option id="SVC">&#36;</option>
            <option id="SYP">&#163;</option>
            <option id="SZL">&#76;</option>
            <option id="THB">&#3647;</option>
            <option id="TJS">&#84;&#74;&#83;</option>
            <option id="TMT">&#109;</option>
            <option id="TND">&#1583;.&#1578;</option>
            <option id="TOP">&#84;&#36;</option>
            <option id="TRY">&#8356;</option>
            <option id="TTD">&#36;</option>
            <option id="TWD">&#78;&#84;&#36;</option>
            <option id="TZS"></option>
            <option id="UAH">&#8372;</option>
            <option id="UGX">&#85;&#83;&#104;</option>
            <option id="USD">&#36;</option>
            <option id="UYU">&#36;&#85;</option>
            <option id="UZS">&#1083;&#1074;</option>
            <option id="VEF">&#66;&#115;</option>
            <option id="VND">&#8363;</option>
            <option id="VUV">&#86;&#84;</option>
            <option id="WST">&#87;&#83;&#36;</option>
            <option id="XAF">&#70;&#67;&#70;&#65;</option>
            <option id="XCD">&#36;</option>
            <option id="XDR"></option>
            <option id="XOF"></option>
            <option id="XPF">&#70;</option>
            <option id="YER">&#65020;</option>
            <option id="ZAR">&#82;</option>
            <option id="ZMK">&#90;&#75;</option>
            <option id="ZWL">&#90;&#36;</option>                                           
        </select>
    </div>  



    <!-- Mainly scripts -->
    <script src="<?php echo e(asset ('js/jquery-3.1.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset ('js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset ('js/plugins/metisMenu/jquery.metisMenu.js')); ?>"></script>
    <script src="<?php echo e(asset ('js/plugins/slimscroll/jquery.slimscroll.min.js')); ?>"></script>

    <!-- Custom and plugin javascript -->
    <script src="<?php echo e(asset ('js/inspinia.js')); ?>"></script>
    <script src="<?php echo e(asset ('js/plugins/pace/pace.min.js')); ?>"></script>

    <!-- Sweet alert -->
    <script src="<?php echo e(asset ('js/plugins/sweetalert/sweetalert.min.js')); ?>"></script>

    <!-- FooTable -->
    <script src="<?php echo e(asset ('js/plugins/footable/footable.all.min.js')); ?>"></script>

    <!-- Page-Level Scripts -->
    <script>
        var delete_country;

        $(document).ready(function() 
        {
            $("#side8").addClass("activeSM");
            $("#side8 a").css("color","#224ea6");

            viewCountries();

            //Empty List
            $('#swal_btn').click(function(){
                swal({
                     title: "List is Empty!",
                    text: "Please add a Country.",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                    closeOnConfirm: false
                }, function () {
                    window.location.assign("<?php echo e(url('add_country')); ?>");
                });
            });

            //Delete Row
            $('#swal_btn2').click(function(){
                swal({
                    title: "Country Deleted!",
                    text: "",
                    type: "success",
                    confirmButtonColor: "#DD6B55",
                });
            });
        });

        function viewCountries()
        {
            var $list = $("#country_list");
            $list.empty();
            $.ajax({
                url: "/DCL/api/CountryView",
                type: "Post",
                success: function(data)
                {   
                    var count = 1;
                    //var dat = jQuery.parseJSON(data);
                    if ( data.status == "success")
                    {
                        $.each(data.data, function(index,obj) 
                        {
                            var currencySymbol = $('#'+obj.CurrencySymbol).text();

                            $list.append('<tr>'+
                                            '<td><strong>'+count+'</strong></td>'+
                                            '<td>'+obj.Name+'</td>'+
                                            '<td>'+obj.PhoneCode+'</td>'+
                                            '<td>'+obj.CurrencyCode+'</td>'+
                                            '<td>'+currencySymbol+'</td>'+
                                            '<td>'+
                                                '<div class="btn-group">'+
                                                    '<button id="'+obj.CountryID+'" onclick ="saveCountry(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/edit_icon.png" /></button>'+
                                                    '<button id="'+obj.CountryID+'" onclick ="deleteCountryModal(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/delete_icon.png" /></button>'+
                                                '</div>'+
                                            '</td>'+
                                        '</tr>');
                            count++;
                        });
                    }
                    else
                    {
                        swal_btn.click();
                    }
                },
                error: function(data)
                {
                }           
            });        
        }

        function deleteCountryModal(id)
        {
            $('#deleteModal').modal('show');
            delete_country = id;
        }


        function deleteCountry()
        {
            $('#deleteModal').modal('hide');

            var country_id = delete_country;
            $.ajax({            
                url: "/DCL/api/CountryDelete",
                type: "POST",
                data: {"CountryID": country_id},
                success: function(data)
                {
                    //var data = jQuery.parseJSON(result);
                    if(data.status == "success")
                    {
                        swal_btn2.click();
                        viewCountries();
                    }
                    else if (data.status == "failed")
                    {
                        alert("failed");
                    }
                },
                error: function(data) 
                {
                }           
            });
        }

        function saveCountry(id)
        {
            var country_id = id;
            localStorage.setItem("country_id",country_id);
            window.location.href = "<?php echo e(url('edit_country')); ?>";
            
        }
    </script>
</body>
</html>
