<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>King Of Scooters | Add Parents Text</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">
    <link href="css/animate.css" rel="stylesheet">
    <link href="css/plugins/summernote/summernote.css" rel="stylesheet">
    <link href="css/plugins/summernote/summernote-bs3.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
     <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">

    <!-- Ladda style -->
    <link href="css/ladda-themeless.min.css" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
</head>
<body>
    <div id="wrapper">
        <?php
            include 'navbar_static_side.php';
        ?>
        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php
                include 'navbar_static_top.php';
                ?>
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><strong>Add Parents Text</strong></h2>
                    <ol class="breadcrumb">
                        <li>
                            <a href="parents_text.php">Parents Text</a>
                        </li>
                        <li class="active">
                            <strong>Add Parents Text</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">

                </div>
            </div>
            <div class="wrapper wrapper-content">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox float-e-margins">
                            <div class="ibox-content">
                                <form id="add_parents_text_form">
                                    <div class="form-group">
                                        <label>Subject</label>
                                        <input type="text" id="subject" name="subject" placeholder="Enter Subject" class="form-control" required>
                                    </div>
                                     <div class="form-group">
                                        <label>Heading</label>
                                        <input type="text" id="heading" name="heading" placeholder="Enter Heading" class="form-control" required>
                                    </div> 
                                    <div class="form-group">
                                        <label>Description</label>
                                        <textarea class="summernote" rows="4" cols="50" id="description" name="description">
                                            <h3>Please enter your Parents Text here</h3>
                                        </textarea>
                                    </div>                                  
                                    <div>
                                        <button style="background-color: #003399;border-color: #224ea6;color: white;" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                                <span class="ladda-label">Submit</span><span class="ladda-spinner"></span>
                                        </button>
                                        <!-- Successfully Added Location -->
                                        <button id="swal_btn" type="button" style="display:none"></button>
                                        <!-- Location not  Added -->
                                        <button id="swal_btn2" type="button" style="display:none"></button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php
                include 'footer.php';
            ?>
        </div>
    </div>

    <!-- Mainly scripts -->
    <script src="js/jquery-3.1.1.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
    <script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>

    <!-- Custom and plugin javascript -->
    <script src="js/inspinia.js"></script>
    <script src="js/plugins/pace/pace.min.js"></script>

    <!-- Sweet alert -->
    <script src="js/plugins/sweetalert/sweetalert.min.js"></script>

    <!-- Jquery Validate -->
    <script src="js/plugins/validate/jquery.validate.min.js"></script>

    <!-- Ladda -->
    <script src="js/plugins/ladda/spin.min.js"></script>
    <script src="js/plugins/ladda/ladda.min.js"></script>
    <script src="js/plugins/ladda/ladda.jquery.min.js"></script>

    <!-- SUMMERNOTE -->
    <script src="js/plugins/summernote/summernote.min.js"></script>

    <script>
        $(document).ready(function()
        {
            $('.summernote').summernote();
        
            $("#side10").addClass("activeSM");
            $("#side10 a").css("color","#224ea6");

            $("#add_parents_text_form").validate({
                rules: 
                {
                    subject: {
                       required: true
                    },
                    heading: {
                        required: true,
                    },
                },
                messages: 
                {
                },
                submitHandler: function(form) 
                {
                    var l = $( '.ladda-button-demo' ).ladda();
                    l.ladda( 'start' );

                    var subject = $('#subject').val();
                    var heading = $('#heading').val();
                    var description = $('#description').val();

                    var formData = new FormData();
                    formData.append("subject", subject);
                    formData.append("heading", heading);
                    formData.append("description", description);
                                                            
                    $.ajax
                    ({
                        type:'POST',
                        url:"/kos_apis/add_parental_text.php",
                        data: formData,
                        contentType: false,
                        cache: false,
                        processData:false,
                        success: function(data)
                        {                        
                            var dat = jQuery.parseJSON(data);
                            if( dat.status == "success" )
                            {
                                l.ladda('stop');
                                swal_btn.click();
                            }
                            else if( dat.status == "failed" )
                            {
                                l.ladda('stop');
                                swal_btn2.click();
                            }
                        },
                        error: function(data) 
                        {
                            alert("error");
                        }           

                    });                
                    return false; // extra insurance preventing the default form action
                }
            });

            $('#swal_btn').click(function(){
                swal({
                    title: "Added Successfully!",
                    text: "",
                    type: "success",
                    confirmButtonColor: "#003399",
                    closeOnConfirm: false
                }, function () {
                    window.location.assign("parents_text.php");
                });
            });

            $('#swal_btn2').click(function(){
                swal({
                     title: "Operation Unsuccessfull!",
                    text: "Parents text not Added.",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                });
            });
        });
    </script>

</body>
</html>
