<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>King Of Scooters | Customer Deal Confirmation</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">
    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">

    <!-- Ladda style -->
    <link href="css/ladda-themeless.min.css" rel="stylesheet">
    
    <style>
    input[type=text], input[type=password] {
    width: 100%;
    padding: 12px 20px;
    margin: 8px 0;
    display: inline-block;
    border: 1px solid #ccc;
    box-sizing: border-box;
}
    /****  floating-Lable style start ****/
    .floating-label { 
      position:relative; 
      margin-bottom:20px; 
    }
    .floating-input{
      font-size:14px;
      padding:4px 4px;
      display:block;
      background-color: transparent;
    }
    
    .floating-input:focus{
         outline:none;
         border-bottom:2px solid #5264AE; 
    }
    
    #label-id {
      color:#999; 
      font-size:14px;
      font-weight:normal;
      position:absolute;
      pointer-events:none;
      left:15px;
      top:15px;
      transition:0.2s ease all; 
      -moz-transition:0.2s ease all; 
      -webkit-transition:0.2s ease all;
    }
    
    .floating-input:focus ~ #label-id, .floating-input:not(:placeholder-shown) ~ #label-id {
      top:-18px;
      font-size:14px;
      color:#224ea6;
    }
    
    /* active state */
    .floating-input:focus ~ .bar:before, .floating-input:focus ~ .bar:after{
      width:50%;
    }
    
    *, *:before, *:after {
        -webkit-box-sizing: border-box;
        -moz-box-sizing: border-box;
        box-sizing: border-box;
    }
    
    /* highlighter */
    .highlight {
      position:absolute;
      height:50%; 
      width:100%; 
      top:15%; 
      left:0;
      pointer-events:none;
      opacity:0.5;
    }
    
    /* active state */
    .floating-input:focus ~ .highlight{
      -webkit-animation:inputHighlighter 0.3s ease;
      -moz-animation:inputHighlighter 0.3s ease;
      animation:inputHighlighter 0.3s ease;
    }
    
    /* animation */
    @-webkit-keyframes inputHighlighter {
    	from { background:#5264AE; }
      to 	{ width:0; background:transparent; }
    }
    @-moz-keyframes inputHighlighter {
    	from { background:#5264AE; }
      to 	{ width:0; background:transparent; }
    }
    @keyframes inputHighlighter {
    	from { background:#5264AE; }
      to 	{ width:0; background:transparent; }
    }
    
    /****  floating-Lable style end ****/
    
    </style>

    <script>
    if (localStorage.customer_login_deal)
    {
        window.stop();
        window.location.replace("deal_details.php");
    }
    </script>

</head>
<body style="background-color: white">
    <div class="wrapper wrapper-content animated fadeInRight">
        <div class="row">
            <div class="col-sm-3"></div>
            <div class="col-lg-6">
                <div class="ibox ">
                    <div class="ibox-content" style="border-color: white">
                        <center>
                            <div class="imgcontainer">
                                <img src="img/logo.png" width="150">
                            </div>
                        </center>
                        <form id="customer_login" style="margin-top: 30px;">
                            <div class="form-group floating-label">
                                <input class="form-control floating-input" type="text" pattern="\d*" placeholder=" " id="user_phone" name="user_phone" required>
                                <span class="highlight"></span>
                                <label id="label-id"><b>Customer Phone#</b></label>
                            </div>
                            <div class="form-group floating-label">
                                <input class="form-control floating-input" type="text" pattern="\d*" placeholder=" " id="otp" name="otp" required>
                                <span class="highlight"></span>
                                <label id="label-id"><b>4 Digit SMS Code</b></label>
                            </div>                                      
                            <div>
                                <button style="background-color: #003399;border-color: #224ea6;color: white; width: 100%; font-size:15px" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                        <span class="ladda-label">Submit</span><span class="ladda-spinner"></span>
                                </button>
                                <!-- Successfully Added Accessory -->
                                <button id="swal_btn" type="button" style="display:none">
                                <!-- Accessory not  Added -->
                                <button id="swal_btn2" type="button" style="display:none">
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="col-sm-3"></div>
        </div>
    </div>     

    <!-- Mainly scripts -->
    <script src="js/jquery-3.1.1.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
    <script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>

    <!-- Custom and plugin javascript -->
    <script src="js/inspinia.js"></script>
    <script src="js/plugins/pace/pace.min.js"></script>

    <script src="js/plugins/jquery-ui/jquery-ui.min.js"></script>

    <!-- Sweet alert -->
    <script src="js/plugins/sweetalert/sweetalert.min.js"></script>

    <!-- Jquery Validate -->
    <script src="js/plugins/validate/jquery.validate.min.js"></script>

    <!-- Ladda -->
    <script src="js/plugins/ladda/spin.min.js"></script>
    <script src="js/plugins/ladda/ladda.min.js"></script>
    <script src="js/plugins/ladda/ladda.jquery.min.js"></script>

    <script>
        $(document).ready(function()
        {
            $("#side5").addClass("activeSM");
            $("#side5 a").css("color","#224ea6");
            
           $("#customer_login").validate({
                rules: 
                {
                    user_phone: {
                       required: true,
                       number: true,
                    },
                    otp: {
                       required: true,
                       number: true
                    },
                },
                messages: 
                {
                },
                submitHandler: function(form) 
                {
                    var l = $( '.ladda-button-demo' ).ladda();
                    l.ladda( 'start' );
                    var swal_btn = document.getElementById("swal_btn");

                    var user_phone = $('#user_phone').val();
                    var otp = $('#otp').val();
                        
                    $.ajax
                    ({
                        url:"/kos_apis/view_order_customer.php",
                        type:'GET',                        
                        data: { "user_phone" : user_phone , "otp" : otp },                    
                        success: function(data)
                        {
                            var dat = jQuery.parseJSON(data);
                            if( dat.status == "success" )
                            {
                                l.ladda('stop');
                                localStorage.setItem("customer_login_deal","login");
                                localStorage.setItem("deal_details",data);
                                window.location.assign("deal_details.php");
                            }
                            else if( dat.status == "failed" )
                            {
                                l.ladda('stop');
                                swal_btn2.click();
                            }
                        },
                        error: function(data) 
                        {
                            alert("error");
                            l.ladda('stop');
                        }           

                    });                
                    return false; // extra insurance preventing the default form action
                }
            });

            $('#swal_btn2').click(function(){
                swal({
                     title: "Operation Unsuccessfull!",
                    text: "Enter Valid Details.",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                });
            });
        });
    </script>
</body>
</html>
