<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>King Of Scooters | Customer Signup</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">
    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">

    <!-- Ladda style -->
    <link href="css/ladda-themeless.min.css" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
    <script>
    if (!localStorage.customer_login_deal)
    {
        window.stop();
        window.location.replace("index.php");
    }
    </script>
</head>

<body>

    <div id="wrapper">
        <!--<?php
        include 'navbar_static_side.php';
        ?>-->
        
        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <!--<?php
                include 'navbar_static_top.php';
                ?>-->
            </div>

            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><Strong>Customer Signup</Strong></h2>
                    <ol class="breadcrumb">
                        <li>
                            <a href="deal_details.php">Deal Details</a>
                        </li>
                        <li class="active">
                            <strong>Customer Signup</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="ibox ">
                            <div class="ibox-content" id="addcustomer_div">
                                <form id="add_customer_form">
                                    <h1><strong>Driver Info</strong></h1>
                                    <div class="form-group">
                                        <label>First Name</label>
                                        <input type="text" id="fname" name="fname" placeholder="Enter first name" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Last Name</label>
                                        <input type="text" id="lname" name="lname" placeholder="Enter last name" class="form-control" required>
                                    </div>                                   
                                    <div class="form-group">
                                        <label>Email</label>
                                        <input type="email" id="email" name="email" placeholder="Enter email" class="form-control" required>
                                    </div>
                                    <div class="form-group" id="password_div">
                                        <label>Password</label>
                                        <input type="password" id="password" name="password" placeholder="Enter Password" class="form-control" required>
                                    </div>
                                    <div class="form-group" id="con_password_div">
                                        <label>Confirm Password</label>
                                        <input type="password" id="confirm_password" name="confirm_password" placeholder="Enter Password" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Date of birth</label>
                                        <div class="row">
                                            <div class="col-xs-12 col-sm-4">
                                                <input class="dobMDY" type="text" id="dob_month" name="dob_month" class="form-control" maxlength="2" placeholder="Month" onchange="CalculateAge();" required>
                                            </div>
                                            <div class="col-xs-12 col-sm-4">
                                                <input class="dobMDY" type="text" id="dob_day" name="dob_day" class="form-control" maxlength="2" placeholder="Day" onchange="CalculateAge();" required>
                                            </div>
                                            <div class="col-xs-12 col-sm-4">
                                                <input class="dobMDY" type="text" id="dob_year" name="dob_year" class="form-control" maxlength="4" placeholder="Year" onchange="CalculateAge();" required>
                                            </div>
                                        </div>
                                    </div> 
                                    <div class="form-group">
                                        <label>Your Age</label>
                                        <input type="text" id="age" name="age" placeholder="Enter your Age" class="form-control" required disabled>
                                    </div>   

                                    <h1><strong>Other Details</strong></h1>
                                    <div class="form-group">
                                        <label>Hotel Name</label>
                                        <input type="text" id="hotel_name" name="hotel_name" placeholder="Enter first name" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Hotel Room#</label>
                                        <input type="text" id="hotel_room_no" name="hotel_room_no" placeholder="Enter last name" class="form-control" required>
                                    </div>   
                                    <div class="form-group">
                                        <label>Car Insurance Company</label>
                                        <input type="text" id="car_insurance_company" name="car_insurance_company" placeholder="Enter first name" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Policy#</label>
                                        <input type="text" id="policy_no" name="policy_no" placeholder="Enter last name" class="form-control" required>
                                    </div>       

                                    <h1><strong>Driving License Details</strong></h1>
                                    <div class="form-group">
                                        <label>License#</label>
                                        <input type="text" id="license_no" name="license_no" placeholder="Enter first name" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Expiry Date</label>
                                        <div class="row">
                                            <div class="col-xs-6">
                                                <input type="number" id="expiry_date_month" name="expiry_date_month" placeholder="Enter Expiry Month" class="form-control" required>
                                            </div>
                                            <div class="col-xs-6">
                                                <input type="number" id="expiry_date_year" name="expiry_date_year" placeholder="Enter Expiry Year" class="form-control" required>
                                            </div>
                                        </div>
                                    </div>   
                                    <div class="form-group">
                                        <label>State</label>
                                        <select class="form-control" id="state" name="state" required="">
                                            <option value="select" selected>Select State</option>
                                            <option value="California">California</option>
                                            <option value="Newyork">Newyork</option>
                                            <option value="Toronto">Toronto</option>
                                            <option value="Ontario">Ontario</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label>
                                            <input type="checkbox" id="check" name="check" required>
                                        I certify that the above information is accurate.</label>
                                    </div>       

                                    <div>
                                        <button style="background-color: #5cb85c;border-color: #5cb85c;color: white;" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                                <span class="ladda-label">NEXT</span><span class="ladda-spinner"></span>
                                        </button>
                                        <!-- Successfully Added Customer -->
                                        <button id="swal_btn" type="button" style="display:none"></button>
                                        <!-- Customer not  Added -->
                                        <button id="swal_btn2" type="button" style="display:none"></button>
                                    </div>
                                </form>
                                <a href="deal_details.php">
                                    <button style="border-color: #003399; background-color: #003399;color: white;margin-left: 70px;margin-top: -50px;" class="btn btn-sm btn-primary m-t-n-xs" data-style="zoom-in">Cancel</button>
                                </a>
                            </div>
                            
                            <!-- EDIT CUSTOMER DIV -->
                            <div class="ibox-content" id="editcustomer_div">
                                <form id="edit_customer_form">
                                    <h1><strong>Driver Info</strong></h1>
                                    <div class="form-group">
                                        <label>First Name</label>
                                        <input type="text" id="fname1" name="fname1" placeholder="Enter first name" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Last Name</label>
                                        <input type="text" id="lname1" name="lname1" placeholder="Enter last name" class="form-control" required>
                                    </div>                                   
                                    <div class="form-group">
                                        <label>Email</label>
                                        <input type="email" id="email1" name="email1" placeholder="Enter email" class="form-control" disabled>
                                    </div>
                                    <!--
                                    <div class="form-group" id="password_div">
                                        <label>Password</label>
                                        <input type="password" id="password" name="password" placeholder="Enter Password" class="form-control" required>
                                    </div>
                                    <div class="form-group" id="con_password_div">
                                        <label>Confirm Password</label>
                                        <input type="password" id="confirm_password" name="confirm_password" placeholder="Enter Password" class="form-control" required>
                                    </div>-->
                                    <div class="form-group">
                                        <label>DOB</label>
                                        <input type="text" id="dob1" name="dob1" class="form-control" disabled>
                                    </div> 
                                    <div class="form-group">
                                        <label>Your Age</label>
                                        <input type="text" id="age1" name="age1" placeholder="Enter your Age" class="form-control" required disabled>
                                    </div>   

                                    <h1><strong>Other Details</strong></h1>
                                    <div class="form-group">
                                        <label>Hotel Name</label>
                                        <input type="text" id="hotel_name1" name="hotel_name1" placeholder="Enter first name" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Hotel Room#</label>
                                        <input type="text" id="hotel_room_no1" name="hotel_room_no1" placeholder="Enter last name" class="form-control" required>
                                    </div>   
                                    <div class="form-group">
                                        <label>Car Insurance Company</label>
                                        <input type="text" id="car_insurance_company1" name="car_insurance_company1" placeholder="Enter first name" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Policy#</label>
                                        <input type="text" id="policy_no1" name="policy_no1" placeholder="Enter last name" class="form-control" required>
                                    </div>       

                                    <h1><strong>Driving License Details</strong></h1>
                                    <div class="form-group">
                                        <label>License#</label>
                                        <input type="text" id="license_no1" name="license_no1" placeholder="Enter first name" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Expiry Date</label>
                                        <div class="row">
                                            <div class="col-xs-6">
                                                <input type="number" id="expiry_date_month1" name="expiry_date_month1" placeholder="Enter Expiry Month" class="form-control" required>
                                            </div>
                                            <div class="col-xs-6">
                                                <input type="number" id="expiry_date_year1" name="expiry_date_year1" placeholder="Enter Expiry Year" class="form-control" required>
                                            </div>
                                        </div>
                                    </div>   
                                    <div class="form-group">
                                        <label>State</label>
                                        <select class="form-control" id="state1" name="state1" required="">
                                            <option value="select" selected>Select State</option>
                                            <option value="California">California</option>
                                            <option value="Newyork">Newyork</option>
                                            <option value="Toronto">Toronto</option>
                                            <option value="Ontario">Ontario</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label>
                                            <input type="checkbox" id="check1" name="check1" required>
                                        I certify that the above information is accurate.</label>
                                    </div>       

                                    <div>
                                        <button style="background-color: #5cb85c;border-color: #5cb85c;color: white;" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                                <span class="ladda-label">NEXT</span><span class="ladda-spinner"></span>
                                        </button>
                                        <!-- Successfully Edited Customer -->
                                        <button id="swal_btn3" type="button" style="display:none"></button>
                                    </div>
                                </form>
                                <a href="deal_details.php">
                                    <button style="border-color: #003399; background-color: #003399;color: white;margin-left: 70px;margin-top: -50px;" class="btn btn-sm btn-primary m-t-n-xs" data-style="zoom-in">Cancel</button>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <?php
                include 'footer.php';
            ?>
        </div>
    </div>

<!-- Mainly scripts -->
<script src="js/jquery-3.1.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>

<!-- Custom and plugin javascript -->
<script src="js/inspinia.js"></script>
<script src="js/plugins/pace/pace.min.js"></script>

<script src="js/plugins/jquery-ui/jquery-ui.min.js"></script>

<!-- Jquery Validate -->
<script src="js/plugins/validate/jquery.validate.min.js"></script>
 <script src="js/plugins/validate/additional-methods.min.js"></script>

<!-- Sweet alert -->
<script src="js/plugins/sweetalert/sweetalert.min.js"></script>

<!-- Ladda -->
<script src="js/plugins/ladda/spin.min.js"></script>
<script src="js/plugins/ladda/ladda.min.js"></script>
<script src="js/plugins/ladda/ladda.jquery.min.js"></script>

<script>
    var errorText;
    var agefixed;
    var ageyear;

    $(document).ready(function()
    {
        viewAgeSetup();
        
        $(".dobMDY").keyup(function () 
        {
            
            if (this.value.length == this.maxLength) 
            {
                alert("Coming");
              $(this).next('.dobMDY').focus();
            }
        });

        if(localStorage.customer_data)
        {
            $('#editcustomer_div').css('display','block');
            $('#addcustomer_div').css('display','none');
            editcustomer();
        }
        else
        {
            $('#editcustomer_div').css('display','none');
            $('#addcustomer_div').css('display','block');
        }

        //Add Customer
        $("#add_customer_form").validate({
            rules: 
            {
                fname: {
                   required: true
                },
                lname: {
                    required: true,
                },
                email: {
                    required: true,
                    email: true
                },
                password: {
                    required: true,
                    /*minlength: 4,
                    maxlength: 4*/
                },  
                confirm_password: {
                    required: true,
                    /*minlength: 4,
                    maxlength: 4,*/
                    equalTo: "#password",
                },                  
                dob_month: {
                    required: true,
                    number: true,
                    maxlength: 2,
                },
                dob_day: {
                    required: true,
                    number: true,
                    maxlength: 2,
                },
                dob_year: {
                    required: true,
                    number: true,
                    maxlength: 4,
                },
                age: {
                    required: true,
                },
                hotel_name: {
                    required: true,
                },  
                hotel_room_no: {
                    required: true,
                },                  
                car_insurance_company: {
                    required: true,
                },
                policy_no: {
                    required: true,
                },
                license_no: {
                    required: true,
                },  
                expiry_date_month: {
                    required: true,
                    number: true,
                }, 
                expiry_date_year: {
                    required: true,
                    number: true,
                },                  
                state: {
                    required: true,
                },
                check: {
                    required: true,
                }
            },
            messages: 
            {
            },
            submitHandler: function(form) 
            {
                var l = $( '.ladda-button-demo' ).ladda();
                l.ladda( 'start' );

                var fname = $('#fname').val();
                var lname = $('#lname').val();
                var email = $('#email').val();
                var password = $('#password').val();
                var dob_day = $('#dob_day').val();
                var dob_month = $('#dob_month').val();
                var dob_year = $('#dob_year').val();
                var dob = dob_month + "-" + dob_day + "-" + dob_year;
                
                var age = $('#age').val();
                var hotel_name = $('#hotel_name').val();
                var hotel_room_no = $('#hotel_room_no').val();
                var car_insurance_company = $('#car_insurance_company').val();
                var policy_no = $('#policy_no').val();
                var license_no = $('#license_no').val();
                var expiry_date_month = $('#expiry_date_month').val();
                var expiry_date_year = $('#expiry_date_year').val();
                var state = $('#state').val();
                
                localStorage.customerDealEmail = email;
                
                var deal_details = jQuery.parseJSON(localStorage.deal_details);
                
                var customer_signup_dealId;
                var customer_signup_phone;
                var customer_drivinglicense_front;
                var customer_drivinglicense_back;

                $.each(deal_details.order_details, function(index,obj) 
                {                    
                    customer_signup_dealId = obj.deal_id;
                    customer_signup_phone = obj.user_phone;
                    customer_drivinglicense_front = obj.driv_license_front;
                    customer_drivinglicense_back = obj.driv_license_back;
                });   

                var formData = new FormData();
                formData.append("deal_id",customer_signup_dealId);
                formData.append("fname", fname);
                formData.append("lname", lname);
                formData.append("customer_email", email);
                formData.append("password", password);
                formData.append("customer_phone", customer_signup_phone);
                formData.append("dob", dob);
                formData.append("age", age);
                formData.append("hotel_name", hotel_name);
                formData.append("hotel_room_no", hotel_room_no);
                formData.append("car_insurance_comp", car_insurance_company);
                formData.append("policy_no", policy_no);
                formData.append("dl_no", license_no);
                formData.append("dl_exmonth", expiry_date_month);
                formData.append("dl_exyear", expiry_date_year);                
                formData.append("state", state);
                formData.append("home_add", "as");
                formData.append("city", "asd");
                formData.append("signup_time","1 aug");
                formData.append("zipcode", "234");
                formData.append("customer_dl_front", customer_drivinglicense_front);
                formData.append("customer_dl_back", customer_drivinglicense_back);

                $.ajax
                ({
                    type:'POST',
                    url:"/kos_apis/customer_signup.php",
                    data: formData,
                    contentType: false,
                    cache: false,
                    processData:false,
                    success: function(data)
                    {                        
                        var dat = jQuery.parseJSON(data);
                        if( dat.status == "success" )
                        {
                            l.ladda('stop');
                            if ( ageyear < agefixed )
                            {
                                $.ajax
                                ({
                                    type:'POST',
                                    url:"/kos_apis/updatedeal_status.php",
                                    data: {"deal_id": customer_signup_dealId , "verification_status" : "waiting" },
                                    success: function(data)
                                    {
                                        var temp = fname + lname;
                                        localStorage.smallName = temp;
                                        window.location.assign("parents_waiver.php");
                                    },
                                    error: function(data) 
                                    {
                                        alert("error");
                                    }           
                                });
                            }
                            else
                            {
                                $.ajax
                                ({
                                    type:'POST',
                                    url:"/kos_apis/updatedeal_status.php",
                                    data: {"deal_id": customer_signup_dealId , "verification_status" : "unverified" },
                                    success: function(data)
                                    {
                                        window.location.assign("rental_agreement.php");
                                    },
                                    error: function(data) 
                                    {
                                        alert("error");
                                    }           
                                });
                            }
                        }
                        else if( dat.status == "failed" )
                        {
                            l.ladda('stop');
                            errorText = dat.error;
                            swal_btn2.click();
                        }
                    },
                    error: function(data) 
                    {
                        alert("error");
                    }           
                });
                return false; // extra insurance preventing the default form action
            }
        });
        
        //Edit Customer
        $("#edit_customer_form").validate({
            rules: 
            {
                fname1: {
                   required: true
                },
                lname1: {
                    required: true,
                },  
                age1: {
                    required: true,
                    number: true,
                },
                hotel_name1: {
                    required: true,
                },  
                hotel_room_no1: {
                    required: true,
                },                  
                car_insurance_company1: {
                    required: true,
                },
                policy_no1: {
                    required: true,
                },
                license_no1: {
                    required: true,
                },  
                expiry_date_month1: {
                    required: true,
                    number: true,
                }, 
                expiry_date_year1: {
                    required: true,
                    number: true,
                },                  
                state1: {
                    required: true,
                },
                check1: {
                    required: true,
                }
            },
            messages: 
            {
            },
            submitHandler: function(form) 
            {
                var l = $( '.ladda-button-demo' ).ladda();
                l.ladda( 'start' );

                var fname = $('#fname1').val();
                var lname = $('#lname1').val();
                var email = $('#email1').val();
                var dob = $('#dob1').val();
                var age = $('#age1').val();
                var hotel_name = $('#hotel_name1').val();
                var hotel_room_no = $('#hotel_room_no1').val();
                var car_insurance_company = $('#car_insurance_company1').val();
                var policy_no = $('#policy_no1').val();
                var license_no = $('#license_no1').val();
                var expiry_date_month = $('#expiry_date_month1').val();
                var expiry_date_year = $('#expiry_date_year1').val();
                var state = $('#state1').val();
                
                localStorage.customerDealEmail = email;

                var deal_details = jQuery.parseJSON(localStorage.deal_details);
                
                var customer_signup_dealId;
                var customer_signup_phone;
                var customer_drivinglicense_front;
                var customer_drivinglicense_back;

                $.each(deal_details.order_details, function(index,obj) 
                {                    
                    customer_signup_dealId = obj.deal_id;
                    customer_signup_phone = obj.user_phone;
                    customer_drivinglicense_front = obj.driv_license_front;
                    customer_drivinglicense_back = obj.driv_license_back;
                });   

                var formData = new FormData();
                formData.append("deal_id",customer_signup_dealId);
                formData.append("fname", fname);
                formData.append("lname", lname);
                formData.append("customer_email", email);
                formData.append("customer_phone", customer_signup_phone);
                formData.append("dob", dob);
                formData.append("age", age);
                formData.append("hotel_name", hotel_name);
                formData.append("hotel_room_no", hotel_room_no);
                formData.append("car_insurance_comp", car_insurance_company);
                formData.append("policy_no", policy_no);
                formData.append("dl_no", license_no);
                formData.append("dl_exmonth", expiry_date_month);
                formData.append("dl_exyear", expiry_date_year);                
                formData.append("state", state);
                formData.append("home_add", "as");
                formData.append("city", "asd");
                formData.append("signup_time","1 aug");
                formData.append("zipcode", "234");
                formData.append("customer_dl_front", customer_drivinglicense_front);
                formData.append("customer_dl_back", customer_drivinglicense_back);

               $.ajax
                ({
                    type:'POST',
                    url:"/kos_apis/edit_customer.php",
                    data: formData,
                    contentType: false,
                    cache: false,
                    processData:false,
                    success: function(data)
                    {                        
                        var dat = jQuery.parseJSON(data);
                        if( dat.status == "success" )
                        {
                            l.ladda('stop');
                            if ( ageyear < agefixed )
                            {
                                $.ajax
                                ({
                                    type:'POST',
                                    url:"/kos_apis/updatedeal_status.php",
                                    data: {"deal_id": customer_signup_dealId , "verification_status" : "waiting" },
                                    success: function(data)
                                    {
                                        var temp = fname + lname;
                                        localStorage.smallName = temp;
                                        window.location.assign("parents_waiver.php");
                                    },
                                    error: function(data) 
                                    {
                                        alert("error");
                                    }           
                                });
                            }
                            else
                            {
                                $.ajax
                                ({
                                    type:'POST',
                                    url:"/kos_apis/updatedeal_status.php",
                                    data: {"deal_id": customer_signup_dealId , "verification_status" : "unverified" },
                                    success: function(data)
                                    {
                                        window.location.assign("rental_agreement.php");
                                    },
                                    error: function(data) 
                                    {
                                        alert("error");
                                    }           
                                });
                            }
                        }
                        else if( dat.status == "failed" )
                        {
                            l.ladda('stop');
                            errorText = dat.error;
                            swal_btn2.click();
                        }
                    },
                    error: function(data) 
                    {
                        alert("error");
                    }           
                });                
                return false; // extra insurance preventing the default form action
            }
        });

        $('#swal_btn').click(function(){
            swal({
                title: "Added Successfully!",
                text: "",
                type: "success",
                confirmButtonColor: "#003399",
            });
        });

        $('#swal_btn2').click(function(){
            swal({
                title: "Operation Unsuccessfull!",
                text: errorText,
                type: "warning",
                confirmButtonColor: "#DD6B55",
            });
        });

        $('#swal_btn3').click(function(){
            swal({
                title: "Edited Successfully!",
                text: "",
                type: "success",
                confirmButtonColor: "#003399",
            });
        });
    });
    
    function CalculateAge()
    {
    	var month = $("#dob_month").val();
    	var day = $("#dob_day").val();
    	var year = $("#dob_year").val();
    	
        $.ajax({
                url: '/kos_apis/calculate_age.php',
        		type: 'post',
        		data: {"month":month,"day":day,"year":year},
        		success: function (response)
        		{
        			var dat = jQuery.parseJSON(response);
        			
                    if( dat.status == "success" )
                    {
                        $('#age').val(dat.data);
                        var temp = dat.data.substr(0, 2);
                        ageyear = parseInt(temp);
                    }
                    else if( dat.status == "failed" )
                    {
                    }
        		}
        	});
    }
    
    function editcustomer()
    {
        var obj = jQuery.parseJSON(localStorage.customer_data);  
        
        $('#fname1').val(obj.fname);
        $('#lname1').val(obj.lname);
        $('#email1').val(obj.email);
        $('#dob1').val(obj.dob);
        $('#age1').val(obj.age);
        $('#hotel_name1').val(obj.hotel_name);
        $('#hotel_room_no1').val(obj.hotel_room_no);
        $('#car_insurance_company1').val(obj.car_insurance_comp);
        $('#policy_no1').val(obj.policy_no);
        $('#license_no1').val(obj.dl_no);
        $('#expiry_date_month1').val(obj.dl_exmonth);
        $('#expiry_date_year1').val(obj.dl_exyear);
        $('#state1').val(obj.state);
        
        var temp = obj.age.substr(0, 2);
        ageyear = parseInt(temp);
    }
    
    function viewAgeSetup()
    {
        $.ajax({
            url: "/kos_apis/view_age.php",
            type: "GET",
            success: function(data)
            {   
                var count = 1;
                var dat = jQuery.parseJSON(data);
                if ( dat.status == "success")
                {
                    agefixed = parseInt(dat.age);
                }
            },
            error: function(data)
            {
            }           
        });        
    }

</script>
</body>
</html>
