<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>King Of Scooters | Vehicle</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">

    <!-- FooTable -->
    <link href="css/plugins/footable/footable.core.css" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">

    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
    
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
</head>
<body>
    <div id="wrapper">
        <?php
        include 'navbar_static_side.php';
        ?>

        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php
                include 'navbar_static_top.php';
                ?>
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><strong>Edit All Vehicles</strong></h2>
                    <ol class="breadcrumb">
                        <li>
                            <a href="vehicles.php">Vehicles</a>
                        </li>
                        <li class="active">
                            <strong>Edit All Vehicles</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="row">
                    <div class="col-xs-12 col-sm-6 col-md-4">
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>SNo</th>
                                            <!--<th>Id</th>-->
                                            <th>Scooter#</th>
                                            <!--<th>Tag#</th>
                                            <th>Vin#</th>
                                            <th>Police#</th>
                                            <th>Medallion#</th>
                                            <th>Type</th>
                                            <th>Make</th>
                                            <th>Model</th>
                                            <th>Year</th>
                                            <th>Sold</th>-->
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody id="vehicle_list">
                                        <!-- Dynamically appending Vehicles List -->
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="6">
                                                <ul class="pagination pull-right"></ul>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none">
            <!-- Delete Row -->
            <button id="swal_btn2" type="button" style="display:none">
            <!-- Active/Inactive row -->
            <button id="swal_btn3" type="button" style="display:none">

            <?php
            include 'footer.php';
            ?>
        </div>
    </div>

<!-- Mainly scripts -->
<script src="js/jquery-3.1.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>

<!-- Custom and plugin javascript -->
<script src="js/inspinia.js"></script>
<script src="js/plugins/pace/pace.min.js"></script>

<!-- Sweet alert -->
<script src="js/plugins/sweetalert/sweetalert.min.js"></script>

<!-- FooTable -->
<script src="js/plugins/footable/footable.all.min.js"></script>

<!-- Page-Level Scripts -->
 <script>
    var delete_vehicle;

    $(document).ready(function() 
    {
        $("#side4").addClass("activeSM");
        $("#side4 a").css("color","#224ea6");

        viewVehicles();
        //Empty List
        $('#swal_btn').click(function(){
            swal({
                 title: "List is Empty!",
                text: "Please add Vehicles.",
                type: "warning",
                confirmButtonColor: "#DD6B55",
                closeOnConfirm: false
            }, function () {
                window.location.assign("add_vehicle.php");
            });
        });

        //Delete Row
        $('#swal_btn2').click(function(){
            swal({
                title: "Vehicle Deleted!",
                text: "",
                type: "success",
                confirmButtonColor: "#DD6B55",
            });
        });

        //Active Row
        $('#swal_btn3').click(function(){
            swal({
                 title: "Activated/Deactivated",
                text: "Vehicle Activated/Deactivated Successfully.",
                type: "success",
                confirmButtonColor: "#003399",
            });
        });
    });

    function viewVehicles()
    {
        var $list = $("#vehicle_list");
        $list.empty();
        $.ajax({
            url: "/kos_apis/view_all_vehicles.php",
            type: "GET",
            success: function(data)
            {   
                var count = 1;
                var dat = jQuery.parseJSON(data);
                if ( dat.status == "success")
                {
                    $.each(dat.Data, function(index,obj) 
                    {
                        if( obj.vehicle_active == '0')
                        {
                            var status = '<span id="'+obj.vehicle_id+'" onclick ="statusChange(this.id);" class="label label-danger">Inactive</span>';
                        }
                        else
                        {
                            var status = '<span id="'+obj.vehicle_id+'" onclick ="statusChange(this.id);" class="label label-primary">Active</span>';
                        }
                        
                        $list.append('<tr>'+
                                        '<td><strong>'+count+'</strong></td>'+
                                        '<td><input type="text" value="'+obj.vehicleNo+'" id="scooter_number'+index+'" name="scooter_number" placeholder="Enter scooter #" class="form-control"></td>'+
                                        /*'<td><input type="text" value="'+obj.vehicle_tagNo+'" id="tag_number'+index+'" name="tag_number" placeholder="Enter tag #" class="form-control"></td>'+
                                        '<td><input type="text" value="'+obj.vehicle_vinNo+'" id="vin_number'+index+'" name="vin_number" placeholder="Enter vin #" class="form-control" ></td>'+
                                        '<td><input type="text" value="'+obj.vehicle_policeNo+'" id="police_number'+index+'" name="police_number" placeholder="Enter police #" class="form-control" ></td>'+
                                        '<td><input type="text" value="'+obj.vehicle_medallionNo+'" id="medallion_number'+index+'" name="medallion_number" placeholder="Enter medallion #" class="form-control" ></td>'+
                                        '<td><input type="text" value="'+obj.vehicle_make+'" id="make'+index+'" name="make" placeholder="Enter Make" class="form-control" ></td>'+
                                        '<td><input type="text" value="'+obj.vehicle_model+'" id="model'+index+'" name="model" placeholder="Enter model" class="form-control" ></td>'+
                                        '<td><input type="text" value="'+obj.vehicle_year+'" id="year'+index+'" name="year" placeholder="Enter year" class="form-control" ></td>'+
                                        '<td><input type="text" value="'+obj.vehicle_sold+'" id="sold'+index+'" name="sold" placeholder="Enter model" class="form-control" ></td>'+*/
                                        '<td>'+
                                            '<div class="btn-group">'+
                                                '<button id="'+obj.vehicle_id+'_'+index+'" onclick ="editAllvehicles(this.id);" class="ladda-button ladda-button-demo btn-white btn btn-xs"><span class="ladda-label">EDIT</span><span class="ladda-spinner"></span></button>'+
                                            '</div>'+
                                        '</td>'+
                                    '</tr>');
                        count++;
                    });
                }
                else
                {
                    swal_btn.click();
                }
            },
            error: function(data)
            {
            }           
        });        
    }

    function editAllvehicles(id)
    {
        var temp = id.split('_');
        var vehicle_id = temp[0];
        
        var scooter_number = $('#scooter_number'+temp[1]).val();
        /*var tag_number = $('#tag_number'+temp[1]).val();
        var vin_number = $('#vin_number'+temp[1]).val();
        var police_number = $('#police_number'+temp[1]).val();
        var medallion_number = $('#medallion_number'+temp[1]).val();
        var make = $('#make'+temp[1]).val();
        var model = $('#model'+temp[1]).val();
        var year = $('#year'+temp[1]).val();
        var sold = $('#sold'+temp[1]).val();*/
        
        var formData = new FormData();
        formData.append("vehicle_id", vehicle_id);
        formData.append("vehicleNo", scooter_number);
        formData.append("vehicle_tagNo", "tag_number");
        formData.append("vehicle_vinNo", "vin_number");                
        formData.append("vehicle_policeNo", "police_number");
        formData.append("vehicle_medallionNo", "medallion_number");
        formData.append("vehicle_make", "make");
        formData.append("vehicle_model", "model");
        formData.append("vehicle_year", "year");
        formData.append("vehicle_size", "size");
        formData.append("vehicle_cost", "cost");
        formData.append("vehicle_minforsale", "min_for_sale");
        formData.append("vehicle_minforrent", "min_for_rent");
        formData.append("vehicle_mileage", "mileage");
        formData.append("vehicle_sold", "sold");
        formData.append("vehicle_info", "Vehicle_info");
        formData.append("vehicle_type", "type_of_scooter");
        
        $.ajax({            
            type:'POST',
            url:"/kos_apis/edit_vehicle.php",
            data: formData,
            contentType: false,
            cache: false,
            processData:false,
            success: function(result)
            {
                var data = jQuery.parseJSON(result);
                if(data.status == "success")
                {
                    alert("Edited");
                    //viewVehicles();
                }
                else if (data.status == "failed")
                {
                    l.ladda( 'stop' );
                    alert("failed");
                }
            },
            error: function(data) 
            {
            }           
        });        
    }
</script>
</body>
</html>
