<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>King Of Scooters | Reject Customer</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">

    <!-- FooTable -->
    <link href="css/plugins/footable/footable.core.css" rel="stylesheet">

    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
    <style>
.switch {
  position: relative;
  display: inline-block;
  width: 60px;
  height: 34px;
}

.switch input { 
  opacity: 0;
  width: 0;
  height: 0;
}

.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider:before {
  position: absolute;
  content: "";
  height: 26px;
  width: 26px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider {
  background-color: red;
}

input:focus + .slider {
  box-shadow: 0 0 1px red;
}

input:checked + .slider:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}

/* Rounded sliders */
.slider.round {
  border-radius: 34px;
}

.slider.round:before {
  border-radius: 50%;
}
</style>
</head>

<body>

    <div id="wrapper">
        <?php
        include 'navbar_static_side.php';
        ?>

        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php
                    include 'navbar_static_top.php';
                ?>
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><strong>Reject Customer</strong></h2>
                </div>
                <div class="col-lg-2">
                </div>
            </div>

            <div class="row" style="margin-top: 20px">    
                    <div class="col-md-6 col-sm-8 col-xs-12">
                        <div class="input-group">
                            <div class="input-group-btn search-panel">
                                <button style="background-color: #566b8a;color: white;" type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown">
                                    <span id="search_concept">Filter by</span> <span class="caret"></span>
                                </button>
                                <ul class="dropdown-menu" role="menu">
                                  <li><a href="#Phone">Customer Phone</a></li>
                                  <li><a href="#Email">Customer Email</a></li>
                                </ul>
                            </div>
                            <input type="hidden" name="search_param" value="all" id="search_param">         
                            <input type="text" class="form-control" id="search_box" name="search_box" placeholder="Search term...">
                            <span class="input-group-btn">
                                <button onclick="searchFilter()" class="btn btn-default" type="button"><span class="glyphicon glyphicon-search"></span></button>
                            </span>
                        </div>
                    </div>
                </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <!--<th>SNo</th>-->
                                            <th>First Name</th>
                                            <th>Last Name</th>
                                            <th>Customer Email</th>
                                            <th>Customer Phone#</th>
                                            <th>BLOCK/UNBLOCK</th>
                                        </tr>
                                    </thead>
                                    <tbody id="customer_list">
                                       <!-- Dynamically appending Accessories List -->
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="6">
                                                <ul class="pagination pull-right"></ul>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none">

            <?php
            include 'footer.php';
            ?>

        </div>
    </div>

<!-- Mainly scripts -->
<script src="js/jquery-3.1.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>

<!-- Custom and plugin javascript -->
<script src="js/inspinia.js"></script>
<script src="js/plugins/pace/pace.min.js"></script>

<!-- Sweet alert -->
<script src="js/plugins/sweetalert/sweetalert.min.js"></script>

<!-- FooTable -->
<script src="js/plugins/footable/footable.all.min.js"></script>

<!-- Page-Level Scripts -->
<script>
    var reject_id;
    var reject_msg;

    $(document).ready(function() 
    {
        $("#side13").addClass("activeSM");
        $("#side13 a").css("color","#224ea6");

        $('.search-panel .dropdown-menu').find('a').click(function(e) 
        {
            e.preventDefault();
            var param = $(this).attr("href").replace("#","");
            var concept = $(this).text();
            $('.search-panel span#search_concept').text(concept);
            $('.input-group #search_param').val(param);
        });

        //Empty List
        $('#swal_btn').click(function(){
            swal({
                 title: "BLOCK/UNBLOCK",
                text: reject_msg,
                type: "success",
                confirmButtonColor: "#DD6B55",
            });
        });
    });

    function searchFilter()
    {
        var search_option = $('#search_concept').html();

        if(search_option == "All")
        {
            $('#search_box').val("All");
        }
        var search_value = $('#search_box').val();

        if( search_option != "Filter by" && search_value )
        {
            var temp;
            if( search_option == "Customer Phone")
                temp = "/kos_apis/viewcustomer.php?user_phone="+search_value;
            else
                temp = "/kos_apis/viewcustomer.php?customer_email="+search_value;

            var $list = $("#customer_list");
            $list.empty();
            $.ajax({
                url: temp,
                type: "GET",
                success: function(data)
                {   
                    var dat = jQuery.parseJSON(data);
                    if ( dat.status == "success")
                    {
                        $.each(dat.customer_details, function(index,obj) 
                        {
                            var checkbox;

                            if( obj.cus_status == 'rejected')
                            {
                                reject_msg = "Customer has been UNBLOCKED successfully";
                                checkbox = '<input type="checkbox" id="'+obj.customer_email+'" onclick ="rejectCustomer(this.id);" checked>';
                            }
                            else
                            {
                                reject_msg = "Customer has been BLOCKED successfully";
                                checkbox = '<input type="checkbox" id="'+obj.customer_email+'" onclick ="rejectCustomer(this.id);">';
                            }

                            $list.append('<tr>'+
                                            '<td>'+obj.fname+'</td>'+
                                            '<td>'+obj.lname+'</td>'+
                                            '<td>'+obj.customer_phone+'</td>'+
                                            '<td>'+obj.customer_email+'</td>'+
                                            '<td>'+
                                                '<label class="switch">'+
                                                  checkbox+
                                                  '<span class="slider round"></span>'+
                                                '</label>'+
                                            '</td>'+
                                        '</tr>');
                        });
                    }
                    else
                    {
                       $list.append("No Information Found");
                    }
                },
                error: function(data)
                {
                }           
            });
        }
        else
        {
            alert("Please select filter and enter search parameter");
        }      
    }

    function rejectCustomer(id)
    {
        reject_id = id;

        $.ajax({            
            url: "/kos_apis/reject_customer.php",
            type: "get",
            data: {"customer_email": reject_id},
            success: function(result)
            {
                var data = jQuery.parseJSON(result);
                if(data.status == "success")
                {
                    swal_btn.click();
                    searchFilter();
                }
                else if (data.status == "failed")
                {
                    alert("failed");
                }
            },
            error: function(data) 
            {
            }           
        });
    }
</script>
</body>
</html>
