<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>King Of Scooters | Force Return</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">

    <!-- FooTable -->
    <link href="css/plugins/footable/footable.core.css" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">

    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
    <script>
    if (!localStorage.login_var_ver2)
    {
        window.stop();
        window.location.replace("index.php");
    }
    </script>
</head>
<body>
    <div id="wrapper">
        <?php
        include 'navbar_static_side.php';
        ?>

        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php
                include 'navbar_static_top.php';
                ?>
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><strong>Force Return</strong></h2>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="row">    
                    <div class="col-md-6 col-sm-8 col-xs-12">
                        <div class="input-group">
                            <div class="input-group-btn search-panel">
                                <button style="background-color: #566b8a;color: white;" type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown">
                                    <span id="search_concept">Search by Vehicle No</span>
                                </button>
                                <!--<ul class="dropdown-menu" role="menu">
                                  <li><a href="#Restaurant Name">Restaurant Name</a></li>
                                  <li><a href="#School Name">School Name</a></li>
                                  <li><a href="#Today's Orders">Today's Orders</a></li>
                                  <li class="divider"></li>
                                  <li><a href="#All">All</a></li>
                                </ul>-->
                            </div>
                            <input type="hidden" name="search_param" value="all" id="search_param">         
                            <input type="text" class="form-control" id="search_box" name="search_box" placeholder="Search Vehicle...">
                            <span class="input-group-btn">
                                <button onclick="searchFilter()" class="btn btn-default" type="button"><span class="glyphicon glyphicon-search"></span></button>
                            </span>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>SNo</th>
                                            <th id="vehNO" onclick="SortByVehicle(this.id)">Vehicle No <span class="caret"></span></th>
                                            <th>Terms</th>
                                            <th>Rentout Time</th>
                                            <th>Return Time</th>
                                            <!--<th>Location</th>
                                            <th>Phone</th>
                                            <th>Checkout Gas</th>-->
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody id="vehicle_list">
                                        <!-- Dynamically appending Vehicles List -->
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="6">
                                                <ul class="pagination pull-right"></ul>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none">
            <!-- Delete Row -->
            <button id="swal_btn2" type="button" style="display:none">
            <!-- Active/Inactive row -->
            <button id="swal_btn3" type="button" style="display:none">

            <?php
            include 'footer.php';
            ?>

        </div>
    </div>

    <!-- Delete Modal -->
    <div class="modal fade" id="deleteModal" role="dialog">
        <div class="modal-dialog">
          <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Return Vehicle Forcefully</h4>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to Return Vehicle Forcefully?</p>
                </div>
                <div class="modal-footer">
                     <button type="button" class="btn btn-default" style="background-color: #1ab394; color: white" onclick="forceDeleteVehicle()">Yes</button>
                    <button type="button" class="btn btn-default" style="background-color: #ed5565; color: white" data-dismiss="modal">No</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal Close -->
    
    <!-- Details Modal -->
    <div class="modal fade" id="detailsModal" role="dialog">
        <div class="modal-dialog">
          <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Vehicle Details</h4>
                </div>
                <div class="modal-body" id="vehicle_details_list">
                    <center> 
                        <h1><strong>Deal Details</strong></h1>
                        <p>Employee Name: <strong><font id="emp_name"></font></strong></p>
                        <p>Vehicle No: <strong><font id="vehicle_no"></font></strong></p>
                        <p>Terms: <strong><font id="terms"></font></strong></p>
                        <p>Customer Phone: <strong><font id="customer_phone"></font></strong></p>
                        <p>Rentout Time: <strong><font id="rentout_time"></font></strong></p>
                        <p>Return Time: <strong><font id="return_time"></font></strong></p>
                        <p>Rentout Gas: <strong><font id="rentout_gas"></font></strong></p>
                        <p>Location: <strong><font id="location"></font></strong></p>
                        
                        <h1><strong>Inspection Images</strong></h1>
                        <h4>Driving License Image</h4>
                        <img id="license_img" alt="License Image" width="100%" src=""/>
                        <h4>Front Image</h4>
                        <img id="front_img" alt="Front Image" width="100%" src=""/>
                        <h4>Rear Image</h4>
                        <img id="rear_img" alt="Rear Image" width="100%" src=""/>
                        <h4>Right Image</h4>
                        <img id="right_img" alt="Right Image" width="100%" src=""/>
                        <h4>Left Image</h4>
                        <img id="left_img" alt="Left Image" width="100%" src=""/>
                    </center>
                </div>
                <div class="modal-footer">
                    <!--<button type="button" class="btn btn-default" style="background-color: #ed5565; color: white" data-dismiss="modal">Close</button>-->
                    <button onclick ="deleteVehicle(this.id);" class="forcee btn-danger btn btn-default" data-dismiss="modal">Force Return</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal Close -->


<!-- Mainly scripts -->
<script src="js/jquery-3.1.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>

<!-- Custom and plugin javascript -->
<script src="js/inspinia.js"></script>
<script src="js/plugins/pace/pace.min.js"></script>

<!-- Sweet alert -->
<script src="js/plugins/sweetalert/sweetalert.min.js"></script>

<!-- FooTable -->
<script src="js/plugins/footable/footable.all.min.js"></script>

<!-- Page-Level Scripts -->
 <script>
    var delete_vehicle;
    var bigData;
    var delete_veh_id;

    $(document).ready(function() 
    {
        $("#side13").addClass("activeSM");
        $("#side13 a").css("color","#224ea6");

        viewVehicles();
        //Empty List
        $('#swal_btn').click(function(){
            swal({
                 title: "List is Empty!",
                text: "Please add Vehicles.",
                type: "warning",
                confirmButtonColor: "#DD6B55",
                closeOnConfirm: false
            }, function () {
                window.location.assign("add_vehicle.php");
            });
        });

        //Delete Row
        $('#swal_btn2').click(function(){
            swal({
                title: "Returned!",
                text: "Vehicle Returned Forcefully",
                type: "success",
                confirmButtonColor: "#DD6B55",
            });
        });

        //Active Row
        $('#swal_btn3').click(function(){
            swal({
                 title: "Activated/Deactivated",
                text: "Vehicle Activated/Deactivated Successfully.",
                type: "success",
                confirmButtonColor: "#003399",
            });
        });
    });
    
    function SortByVehicle(id)
    {
        $('#'+id).css('color','#224ea6');
        
        var $list = $("#vehicle_list");
        $list.empty();
        
        bigData.Data.sort(function(a, b)
        {
            return parseFloat(a.vehicle_No) - parseFloat(b.vehicle_No);
        });
        
        var count = 1;
        $.each(bigData.Data, function(index,obj) 
        {
            $list.append('<tr>'+
                            '<td>'+count+'</td>'+
                            '<td><strong>'+obj.vehicle_No+'</strong></td>'+
                            '<td>'+obj.term+'</td>'+
                            '<td>'+obj.checkout_time+'</td>'+
                            '<td>'+obj.return_time+'</td>'+
                            /*'<td>'+obj.location+'</td>'+
                            '<td>'+obj.user_phone+'</td>'+
                            '<td>'+obj.checkout_gas+'</td>'+*/
                            '<td>'+
                                '<div class="btn-group">'+
                                    '<button id="'+obj.vehicle_No+'" onclick ="deleteVehicle(this.id);" class="btn-danger btn btn-xs">Force Return</button>'+
                                '</div>'+
                            '</td>'+
                            '<td>'+
                                '<div class="btn-group">'+
                                    '<button id="'+obj.vehicle_No+'" onclick ="viewDetails(this.id);" class="btn-warning btn btn-xs">View Details</button>'+
                                '</div>'+
                            '</td>'+
                        '</tr>');
            count++;
        }); 
    }

    function viewVehicles()
    {
        var $list = $("#vehicle_list");
        $list.empty();
        $.ajax({
            url: "KOS_dup/kos_apis/view_all_out_vehicles.php",
            type: "GET",
            success: function(data)
            {   
                var count = 1;
                var dat = jQuery.parseJSON(data);
                bigData = dat;
                if ( dat.status == "success")
                {
                    $.each(dat.Data, function(index,obj) 
                    {
                        $list.append('<tr>'+
                                        '<td>'+count+'</td>'+
                                        '<td><strong>'+obj.vehicle_No+'</strong></td>'+
                                        '<td>'+obj.term+'</td>'+
                                        '<td>'+obj.checkout_time+'</td>'+
                                        '<td>'+obj.return_time+'</td>'+
                                        /*'<td>'+obj.location+'</td>'+
                                        '<td>'+obj.user_phone+'</td>'+
                                        '<td>'+obj.checkout_gas+'</td>'+*/
                                        '<td>'+
                                            '<div class="btn-group">'+
                                                '<button id="'+obj.vehicle_No+'" onclick ="deleteVehicle(this.id);" class="btn-danger btn btn-xs">Force Return</button>'+
                                            '</div>'+
                                        '</td>'+
                                        '<td>'+
                                            '<div class="btn-group">'+
                                                '<button id="'+obj.vehicle_No+'" onclick ="viewDetails(this.id);" class="btn-warning btn btn-xs">View Details</button>'+
                                            '</div>'+
                                        '</td>'+
                                    '</tr>');
                        count++;
                    });
                }
                else
                {
                    swal_btn.click();
                }
            },
            error: function(data)
            {
            }           
        });        
    }
    
    function viewVehiclesAgain()
    {
        var $list = $("#vehicle_list");
        $list.empty();
        
        var count = 1;
        $.each(bigData.Data, function(index,obj) 
        {
            $list.append('<tr>'+
                            '<td>'+count+'</td>'+
                            '<td><strong>'+obj.vehicle_No+'</strong></td>'+
                            '<td>'+obj.term+'</td>'+
                            '<td>'+obj.checkout_time+'</td>'+
                            '<td>'+obj.return_time+'</td>'+
                            /*'<td>'+obj.location+'</td>'+
                            '<td>'+obj.user_phone+'</td>'+
                            '<td>'+obj.checkout_gas+'</td>'+*/
                            '<td>'+
                                '<div class="btn-group">'+
                                    '<button id="'+obj.vehicle_No+'" onclick ="deleteVehicle(this.id);" class="btn-danger btn btn-xs">Force Return</button>'+
                                '</div>'+
                            '</td>'+
                            '<td>'+
                                '<div class="btn-group">'+
                                    '<button id="'+obj.vehicle_No+'" onclick ="viewDetails(this.id);" class="btn-warning btn btn-xs">View Details</button>'+
                                '</div>'+
                            '</td>'+
                        '</tr>');
            count++;
        });  
    }
    
    function viewDetails(id)
    {
        //var $list = $("#vehicle_details_list");
        //$list.empty();
        
        $("#license_img").attr("src","");
        $("#front_img").attr("src","");
        $("#rear_img").attr("src","");
        $("#right_img").attr("src","");
        $("#left_img").attr("src","");
        
        $.each(bigData.Data, function(index,obj) 
        {
            if( obj.vehicle_No == id )
            {
                $('#emp_name').html(obj.employee_name);
                $('#vehicle_no').html(obj.vehicle_No);
                $('#terms').html(obj.term);
                $('#customer_phone').html(obj.user_phone);
                $('#rentout_time').html(obj.checkout_time);
                $('#return_time').html(obj.return_time);
                $('#rentout_gas').html(obj.checkout_gas);
                $('#location').html(obj.location);
                
                $(".forcee").attr("id",obj.vehicle_No);
                
                $.each(obj.Inspection_images, function(index2,obj2) 
                {
                    if( obj2.side_name == "license")
                    {
                        $("#license_img").attr("src","https://kingofrental.com/KOS_dup/kos_apis/"+obj2.image);
                    }
                    else if( obj2.side_name == "front")
                    {
                        $("#front_img").attr("src","https://kingofrental.com/KOS_dup/kos_apis/"+obj2.image);
                    }
                    else if( obj2.side_name == "rear")
                    {
                        $("#rear_img").attr("src","https://kingofrental.com/KOS_dup/kos_apis/"+obj2.image);
                    }
                    else if( obj2.side_name == "right")
                    {
                        $("#right_img").attr("src","https://kingofrental.com/KOS_dup/kos_apis/"+obj2.image);
                    }
                    else if( obj2.side_name == "left")
                    {
                        $("#left_img").attr("src","https://kingofrental.com/KOS_dup/kos_apis/"+obj2.image);
                    }
                });

                
            }
        });  
        
        $('#detailsModal').modal('show');
    }
    
    function deleteVehicle(id)
    {
        delete_veh_id = id;
        $('#deleteModal').modal('show');
    }

    function forceDeleteVehicle()
    {
        var vehicle_id = delete_veh_id;
        $('#deleteModal').modal('hide');
        
        $.ajax({            
            url: "KOS_dup/kos_apis/checkint_new.php",
            type: "POST",
            data: {"vehicle_No": vehicle_id},
            success: function(result)
            {
                var data = jQuery.parseJSON(result);
                if(data.status == "success")
                {
                    swal_btn2.click();
                    viewVehicles();
                }
                else if (data.status == "failed")
                {
                    alert("failed");
                }
            },
            error: function(data) 
            {
            }           
        });        
    }
    
    function searchFilter()
    {
        var search_value = $('#search_box').val();
        
        if(search_value)
        {
            var $list = $("#vehicle_list");
            $list.empty();
            
            var count = 1;
            
            $.each(bigData.Data, function(index,obj) 
            {
                if( search_value == obj.vehicle_No )
                {
                    $list.append('<tr>'+
                                    '<td>1</td>'+
                                    '<td><strong>'+obj.vehicle_No+'</strong></td>'+
                                    '<td>'+obj.term+'</td>'+
                                    '<td>'+obj.checkout_time+'</td>'+
                                    '<td>'+obj.return_time+'</td>'+
                                    /*'<td>'+obj.location+'</td>'+
                                    '<td>'+obj.user_phone+'</td>'+
                                    '<td>'+obj.checkout_gas+'</td>'+*/
                                    '<td>'+
                                        '<div class="btn-group">'+
                                            '<button id="'+obj.vehicle_No+'" onclick ="deleteVehicle(this.id);" class="btn-danger btn btn-xs">Force Return</button>'+
                                        '</div>'+
                                    '</td>'+
                                    '<td>'+
                                        '<div class="btn-group">'+
                                            '<button id="'+obj.vehicle_No+'" onclick ="viewDetails(this.id);" class="btn-warning btn btn-xs">View Details</button>'+
                                        '</div>'+
                                    '</td>'+
                                '</tr>'+
                                '<tr><td colspan="5"><button onclick ="viewVehiclesAgain();" class="btn-white btn btn-xs">Go Back</button></td></tr>');
                    count++;
                }
            });
            if( count == 1 )
            {
                $list.append('<tr>'+
                                '<td colspan="5">No Information Found</td>'+
                            '</tr>'+
                            '<tr><td colspan="5"><button onclick ="viewVehiclesAgain();" class="btn-white btn btn-xs">Go Back</button></td></tr>');
            }
        }
        else
        {
            alert("Please select filter and enter search parameter");
        }
    }
    
</script>
</body>
</html>