<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>King Of Scooters | Edit Employee</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">
    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">
    
    <!-- Ladda style -->
    <link href="css/ladda-themeless.min.css" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
    <script>
    if (!localStorage.login_var_ver2)
    {
        window.stop();
        window.location.replace("index.php");
    }
    </script>
</head>

<body>

    <div id="wrapper">
        <?php
        include 'navbar_static_side.php';
        ?>
        
        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php
                include 'navbar_static_top.php';
                ?>
            </div>

            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><Strong>Edit Employee</Strong></h2>
                    <ol class="breadcrumb">
                        <li>
                            <a href="employees.php">Employees</a>
                        </li>
                        <li class="active">
                            <strong>Edit Employee</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="ibox ">
                            <div class="ibox-content">
                                <form id="update_employee_form">
                                    <div class="form-group">
                                        <label>First Name</label>
                                        <input type="text" id="fname" name="fname" placeholder="Enter first name" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Last Name</label>
                                        <input type="text" id="lname" name="lname" placeholder="Enter last name" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Username</label>
                                        <input type="text" id="uname" name="uname" placeholder="Enter Username" class="form-control" disabled="" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Phone</label>
                                        <input type="text" id="number" name="number" placeholder="Enter phone #" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Email</label>
                                        <input type="email" id="email" name="email" placeholder="Enter email" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Email For SMS</label>
                                        <input type="email" id="s_email" name="s_email" placeholder="Enter email for sms" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Password</label>
                                        <input type="password" id="password" name="password" placeholder="Enter Password" class="form-control" required>
                                        <div class="input-group-append">
                                            <input type="checkbox">
                                            <small>Show Password</small>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label>Choose 4-Digit Pin Code</label>
                                        <input type="text" id="pincode" name="pincode" placeholder="Enter Pincode" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Role</label>
                                        <select class="form-control" id="role" name="role" required="">
                                            <option value="select" selected>Select Employee Role</option>
                                            <option value="Employee">Employee</option>
                                            <option value="Manager">Manager</option>
                                            <option value="Secretary">Secretary</option>
                                            <option value="Admin">Admin</option>
                                        </select>
                                    </div>  
                                    <div>
                                        <button style="background-color: #003399;border-color: #224ea6;color: white;" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                                <span class="ladda-label">Submit</span><span class="ladda-spinner"></span>
                                        </button>
                                        <!-- Successfully Updated Employee -->
                                        <button id="swal_btn" type="button" style="display:none">
                                        <!-- Employee not Updated -->
                                        <button id="swal_btn2" type="button" style="display:none">
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <?php
            include 'footer.php';
            ?>
        </div>
    </div>



<!-- Mainly scripts -->
<script src="js/jquery-3.1.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>

<!-- Custom and plugin javascript -->
<script src="js/inspinia.js"></script>
<script src="js/plugins/pace/pace.min.js"></script>

<script src="js/plugins/jquery-ui/jquery-ui.min.js"></script>

<!-- Jquery Validate -->
<script src="js/plugins/validate/jquery.validate.min.js"></script>

<!-- Sweet alert -->
<script src="js/plugins/sweetalert/sweetalert.min.js"></script>

<!-- Ladda -->
<script src="js/plugins/ladda/spin.min.js"></script>
<script src="js/plugins/ladda/ladda.min.js"></script>
<script src="js/plugins/ladda/ladda.jquery.min.js"></script>

<script>
var errmsg;
$(document).ready(function()
{
    $("#side3").addClass("activeSM");
    $("#side3 a").css("color","#224ea6");

    viewEmp();

    $("#update_employee_form").validate({
        rules: 
        {
            fname: {
               required: true
            },
            lname: {
               required: true,
            },
            number: {
               required: true,
               number: true
            },
            email: {
               required: true,
               email: true
            },
            s_email: {
               required: true,
               email: true
            },
            password: {
               required: true,
               minlength: 4,
               maxlength:4
            },        
            pincode: {
                number: true,
                minlength: 4,
                maxlength:4,
            },
            role: {
               required: true,
            },
        },
        messages: 
        {
        },
        submitHandler: function(form) 
        {
            var l = $( '.ladda-button-demo' ).ladda();
            l.ladda( 'start' );

            var fname = $('#fname').val();
            var lname = $('#lname').val();
            var number = $('#number').val();
            var email = $('#email').val();
            var s_email = $('#s_email').val();
            var password = $('#password').val();
            var pincode = $('#pincode').val();
            var role = $('#role').val();
            var emp_id = localStorage.emp_id;
            //var filetoupload = document.getElementById('filetoupload').files[0];
            var formData = new FormData();
            formData.append("emp_fname", fname);
            formData.append("emp_lname", lname);
            formData.append("emp_username", emp_id);
            formData.append("emp_phone", number);
            formData.append("emp_email", email);
            formData.append("emp_emailSMS", s_email);
            formData.append("emp_pass", password);
            formData.append("emp_pincode", pincode);
            formData.append("emp_role", role);
            //formData.append("filetoupload", filetoupload);

           $.ajax
               ({
                    type:'POST',
                    url:"KOS_dup/kos_apis/edit_employee.php",
                    data: formData,
                    contentType: false,
                    cache: false,
                    processData:false,
                    success: function(data)
                    {
                        var dat = jQuery.parseJSON(data);
                        if( dat.status == "success" )
                        {
                            l.ladda('stop');
                            swal_btn.click();
                        }
                        else if( dat.status == "failed" )
                        {
                            errmsg = dat.error;
                            l.ladda('stop');
                            swal_btn2.click();
                        }
                    },
                    error: function(data) 
                    {
                        alert("error");
                    }           

                });                
            return false; // extra insurance preventing the default form action
        }
    });

    $('#swal_btn').click(function(){
        swal({
            title: "Updated Successfully!",
            text: "",
            type: "success",
            confirmButtonColor: "#003399",
            closeOnConfirm: false
        }, function () {
            window.location.assign("employees.php");
        });
    });

    $('#swal_btn2').click(function(){
        swal({
            title: "Operation Unsuccessfull!",
            text: errmsg,
            type: "warning",
            confirmButtonColor: "#DD6B55",
        });
    });

    $('input[type="checkbox"]').click(function()
    {
        if($('input[type="checkbox"]').is(':checked') == true)
        {
            $('#password').attr('type', 'text');
        }
        else
        {
            $('#password').attr('type', 'password');
        }
    });
    
});

function viewEmp()
{
    var emp_id = localStorage.emp_id;

    $.ajax({
        url: "KOS_dup/kos_apis/view_employee.php",
        type: "GET",
        data: {"emp_username": emp_id},
        success: function(data)
        {   
            var dat = jQuery.parseJSON(data);
            if(dat.status == "success")
            {
                $.each(dat.Data, function(i,Employees)
                {
                    $('#fname').val(Employees.emp_fname);
                    $('#lname').val(Employees.emp_lname);
                    $('#uname').val(Employees.emp_username);
                    $('#number').val(Employees.emp_phone);
                    $('#email').val(Employees.emp_email);
                    $('#s_email').val(Employees.emp_emailSMS);
                    $('#password').val(Employees.emp_pass);
                    $('#pincode').val(Employees.emp_pincode);
                    $('#role').val(Employees.emp_role);            
                });            
            }
        },     
    });
}
</script>

</body>
</html>
