<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>King Of Scooters | Vehicle</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">

    <!-- FooTable -->
    <link href="css/plugins/footable/footable.core.css" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">

    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
    <script>
    if (!localStorage.login_var_ver2)
    {
        window.stop();
        window.location.replace("index.php");
    }
    </script>
</head>
<body>
    <div id="wrapper">
        <?php
        include 'navbar_static_side.php';
        ?>

        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php
                include 'navbar_static_top.php';
                ?>
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><strong>Vehicles</strong></h2>
                    <a href="add_vehicle.php">
                        <button type="button" class="btn btn-default btn-sm">
                            <span class="glyphicon glyphicon-plus"></span> Add Vehicle
                        </button>
                    </a>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>SNo</th>
                                            <!--<th>Id</th>-->
                                            <th>Scooter#</th>
                                            <!--<th>Tag#</th>
                                            <th>Vin#</th>
                                            <th>Police#</th>
                                            <th>Medallion#</th>
                                            <th>Make</th>
                                            <th>Model</th>
                                            <th>Year</th>
                                            <th>Sold</th>-->
                                            <th>Type</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody id="vehicle_list">
                                        <!-- Dynamically appending Vehicles List -->
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="6">
                                                <ul class="pagination pull-right"></ul>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none">
            <!-- Delete Row -->
            <button id="swal_btn2" type="button" style="display:none">
            <!-- Active/Inactive row -->
            <button id="swal_btn3" type="button" style="display:none">

            <?php
            include 'footer.php';
            ?>

        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="deleteModal" role="dialog">
        <div class="modal-dialog">
          <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Delete Vehicle</h4>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to delete the Vehicle?</p>
                </div>
                <div class="modal-footer">
                     <button type="button" class="btn btn-default" style="background-color: #1ab394; color: white" onclick="deleteVehicle()">Yes</button>
                    <button type="button" class="btn btn-default" style="background-color: #ed5565; color: white" data-dismiss="modal">No</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal Close -->


<!-- Mainly scripts -->
<script src="js/jquery-3.1.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>

<!-- Custom and plugin javascript -->
<script src="js/inspinia.js"></script>
<script src="js/plugins/pace/pace.min.js"></script>

<!-- Sweet alert -->
<script src="js/plugins/sweetalert/sweetalert.min.js"></script>

<!-- FooTable -->
<script src="js/plugins/footable/footable.all.min.js"></script>

<!-- Page-Level Scripts -->
 <script>
    var delete_vehicle;

    $(document).ready(function() 
    {
        $("#side4").addClass("activeSM");
        $("#side4 a").css("color","#224ea6");

        viewVehicles();
        //Empty List
        $('#swal_btn').click(function(){
            swal({
                 title: "List is Empty!",
                text: "Please add Vehicles.",
                type: "warning",
                confirmButtonColor: "#DD6B55",
                closeOnConfirm: false
            }, function () {
                window.location.assign("add_vehicle.php");
            });
        });

        //Delete Row
        $('#swal_btn2').click(function(){
            swal({
                title: "Vehicle Deleted!",
                text: "",
                type: "success",
                confirmButtonColor: "#DD6B55",
            });
        });

        //Active Row
        $('#swal_btn3').click(function(){
            swal({
                 title: "Activated/Deactivated",
                text: "Vehicle Activated/Deactivated Successfully.",
                type: "success",
                confirmButtonColor: "#003399",
            });
        });
    });

    function viewVehicles()
    {
        var $list = $("#vehicle_list");
        $list.empty();
        $.ajax({
            url: "KOS_dup/kos_apis/view_all_vehicles.php",
            type: "GET",
            success: function(data)
            {   
                var count = 1;
                var dat = jQuery.parseJSON(data);
                if ( dat.status == "success")
                {
                    $.each(dat.Data, function(index,obj) 
                    {
                        if( obj.vehicle_active == '0')
                        {
                            var status = '<span id="'+obj.vehicle_id+'" onclick ="statusChange(this.id);" class="label label-danger">Inactive</span>';
                        }
                        else
                        {
                            var status = '<span id="'+obj.vehicle_id+'" onclick ="statusChange(this.id);" class="label label-primary">Active</span>';
                        }
                        $list.append('<tr>'+
                                        '<td>'+count+'</td>'+
                                        '<td><strong>'+obj.vehicleNo+'</strong></td>'+
                                        /*'<td>'+obj.vehicle_tagNo+'</td>'+
                                        '<td>'+obj.vehicle_vinNo+'</td>'+
                                        '<td>'+obj.vehicle_policeNo+'</td>'+
                                        '<td>'+obj.vehicle_medallionNo+'</td>'+
                                        '<td>'+obj.vehicle_make+'</td>'+
                                        '<td>'+obj.vehicle_model+'</td>'+
                                        '<td>'+obj.vehicle_year+'</td>'+
                                        '<td>'+obj.vehicle_sold+'</td>'+*/
                                        '<td>'+obj.vehicle_type+'</td>'+
                                        '<td>'+status+'</td>'+
                                        '<td>'+
                                            '<div class="btn-group">'+
                                                '<button id="'+obj.vehicle_id+'" onclick ="saveVehicle(this.id);" class="btn-white btn btn-xs">Edit</button>'+
                                                '<button id="'+obj.vehicle_id+'" onclick ="deleteVehicleModal(this.id);" class="btn-white btn btn-xs">Delete</button>'+
                                            '</div>'+
                                        '</td>'+
                                    '</tr>');
                        count++;
                    });
                }
                else
                {
                    swal_btn.click();
                }
            },
            error: function(data)
            {
            }           
        });        
    }

    function deleteVehicleModal(id)
    {
        $('#deleteModal').modal('show');
        delete_vehicle = id;
    }

    function deleteVehicle()
    {
        $('#deleteModal').modal('hide');

        var vehicle_id = delete_vehicle;
        $.ajax({            
            url: "KOS_dup/kos_apis/delete_vehicle.php",
            type: "get",
            data: {"vehicle_id": vehicle_id},
            success: function(result)
            {
                var data = jQuery.parseJSON(result);
                if(data.status == "success")
                {
                    swal_btn2.click();
                    viewVehicles();
                }
                else if (data.status == "failed")
                {
                    alert("failed");
                }
            },
            error: function(data) 
            {
            }           
        });
    }

    function saveVehicle(id)
    {
        var vehicle_id = id;
        localStorage.setItem("vehicle_id",vehicle_id);
        window.location.href = "update_vehicle.php";
        
    }

    function statusChange(id)
    {
        var vehicle_id = id;
        $.ajax({            
            url: "KOS_dup/kos_apis/active_vehicle.php",
            type: "get",
            data: {"vehicle_id": vehicle_id},
            success: function(result)
            {
                var data = jQuery.parseJSON(result);
                if(data.status == "success")
                {
                    swal_btn3.click();
                    viewVehicles();
                }
                else if (data.status == "failed")
                {
                    alert("failed");
                }
            },
            error: function(data) 
            {
            }           
        });        
    }
</script>
</body>
</html>
